/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import java.math.BigInteger;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xmlsec.signature.X509SerialNumber;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class X509SerialNumberTest
extends XMLObjectProviderBaseTestCase {
    private BigInteger expectedBigIntegerContent;

    public X509SerialNumberTest() {
        this.singleElementFile = "/data/org/opensaml/xmlsec/signature/impl/X509SerialNumber.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedBigIntegerContent = new BigInteger("123456789");
    }

    @Test
    public void testSingleElementUnmarshall() {
        X509SerialNumber x509Element = (X509SerialNumber)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)x509Element, (String)"X509SerialNumber");
        Assert.assertEquals((Object)this.expectedBigIntegerContent, (Object)x509Element.getValue(), (String)"X509SerialNumber value");
    }

    @Test
    public void testSingleElementMarshall() {
        X509SerialNumber x509Element = (X509SerialNumber)this.buildXMLObject(X509SerialNumber.DEFAULT_ELEMENT_NAME);
        x509Element.setValue(this.expectedBigIntegerContent);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)x509Element);
    }
}

