/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.XMLSecurityTestingSupport;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.DocumentInternalIDContentReference;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExplicitKeySignatureTrustEngineTest
extends XMLObjectBaseTestCase {
    private X509Certificate signingCert;
    private String signingCertBase64 = "MIIDzjCCAragAwIBAgIBMTANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyMTE4MjM0MFoXDTE3MDUxODE4MjM0MFowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgfQwgfEwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMEAGA1UdEQQ5MDeCEmFzaW1vdi5leGFtcGxlLm9yZ4YbaHR0cDovL2hlaW5sZWluLmV4YW1wbGUub3JnhwQKAQIDMA0GCSqGSIb3DQEBBQUAA4IBAQBLiDMyQ60ldIytVO1GCpp1S1sKJyTF56GVxHh/82hiRFbyPu+2eSl7UcJfH4ZNbAfHL1vDKTRJ9zoD8WRzpOCUtT0IPIA/Ex+8lFzZmujO10j3TMpp8Ii6+auYwi/Tosrfw1YCxF+GI5KO49CfDRr6yxUbMhbTN+ssK4UzFf36UbkeJ3EfDwB0WU70jnlkyO8f97X6mLd5QvRcwlkDMftP4+MB+inTlxDZ/w8NLXQoDW6p/8r91bupXe0xwuyEvow2xjxlzVcux2BZsUZYjBa07ZmNNBtF7WaQqH7l2OBCAdnBhvme5i/e0LK3Ivys+hcVyvCXs5XtFTFWDAVYvzQ6";
    private PrivateKey signingPrivateKey;
    private String signingPrivateKeyBase64 = "MIIEogIBAAKCAQEAzVp5BZoctb2GuoDf8QUSpGcRct7FKtldC7GG+kN6XvUJW+vgc2jOQ6zfLiKqq6ARN1qdC7a4CrkE6Q6TRQXUtqeWn4lLTmC1gQ7Ys0zs7N2d+jBjIyD1GEOLNNyD98j4drnehCqQz4mKszW5EWoiMJmEorea/kTGL3en7ir0zp+oez2SOQA+0XWu1VoeTlUqGV5Ucd6sRYaPpmYVtKuH1H04uZVsH+BIZHwZc4MP5OYH+HDouq6xqUUtc8Zm7V9UQIPiNtM+ndOINDdlrCubLbM4GCqCETiQol8I62mvP0qBXCC6JVkKbbVRwSFGJcg5ZvJiBZXmX+EXhaX5vp1GMQIDAQABAoIBAC1P4lZvHBiqGll66G8pXGS0bXA4Ya9DyTk0UgFU9GKRlSAYWy18Gc9rDNAETD6Uklfxgae9CL0s+D1ovuxDDh3DuwO26sv/oO06Vmyx87GMcThshuOQeSSCeuwOIHyDdvfTqZrmPY/d3KIQn6aNEcBBj7fL5cJncIe20nJGPkB9KuTAaGVnaKoOesxgWBr7SvjGq/SB7bRE1B3cQxwUDWHkF0LljSIkXaV9ehKJcgBY2fV0rc8pI53WsUXEXk5HoqYZnQ5QjAZ4Hf2sbRKevq+D2ENK+OuKNuCAS/oJbGSdS7q0/6jgHZ6cUGXi1r2qEEG7PIorCoSMkWQSM1wMX0ECgYEA9c6/s9lKDrjzyjO9rlxzufGVRDjffiUZ1o8F3RD3JltdPLVcd429CvGSNV730Yr/wSyRAum4vkGnmOR9tuQdi3PJHt3xGRsymTT5ym/5fnC4SvXVSR6vLFPUY80yj+D6/0lwIaGE7x4JOclMXnHjqcpRl14onOjY844WORhxgjkCgYEA1d5NTqp938UbZYKX4Q9UvLf/pVR9xOFOCYnMywAFk0WnkUBPHmPoJuFgeNGeQ7gCmHi7JFzwBjkj6DcGMdbXKWiUij1BoRxf9Mof+fZBWVSKw+/yVLbJkyK951+nywyiq3HCNBti1eK/h/hXQd8t+dCBmDGj1ba1C2/3JZqLg7kCgYArxD1D85uJFYtq5F2Qryt33zj5pbq9hjOcjWi43O10qe3nAk/NhbI0QaEL2bX8XGh/Z8UGJMFdNul1grGTn/hWvS4BTflAxCP1PYaAcgGVbtKRnkX0t/7uwJpfjsjC74chb10Ez/KQdOOlo17yrgqgT8LJVd2bWqZOb20ri1uimQKBgFfJYSg6OWLh0IYRXfBmz5yLVmdx0BJBfTvTEXn+L0utWsP3hsJttfxHpMbTHEilvoMBg6fAclHLoJ6P/33ztuvrXpWD4W2VbRnY4dlDqL1XQ4J7+pelVAaOSy8vB3wEWr1O+61R1HcBFSdl28NRLdkOKjPjpGF0Fsp0EhmgX0YZAoGAXrM4+BUvcx2PLaeneTJoRdOi3GQbdAte03maDU6C474IdgR8IUygfspv3fiGue9Wmk5ybUBlv/D6sIWVhnnedWsg2zAgZPfZ78HLLNhWeEx33wPFiK0wV5MJXQ224gQ5t9D3WXdZtmAxXIFoopj4zToCMBjXyep0u7zl3s7s00U=";
    private X509Certificate otherCert1;
    private String otherCert1Base64 = "MIIECTCCAvGgAwIBAgIBMzANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyNTIwMTYxMVoXDTE3MDUyMjIwMTYxMVowGjEYMBYGA1UEAxMPaWRwLmV4YW1wbGUub3JnMIIBtjCCASsGByqGSM44BAEwggEeAoGBAI+ktw7R9m7TxjaCrT2MHwWNQUAyXPrqbFCcu+DCirr861U6R6W/GyqWdcy8/D1Hh/I1U94POQn5yfqVPpVH2ZRS4OMFndHWaoo9V5LJoXTXHiDYB3W4t9tn0fm7It0n7VoUI5C4y9LG32Hq+UIGF/ktNTmo//mEqLS6aJNdbMFpAhUArmKGh0hcpmjukYArWcMRvipB4CMCgYBuCiCrUaHBRRtqrk0P/Luq0l2M2718GwSGeLPZip06gACDG7IctMrgH1J+ZIjsx6vffi977wnMDiktqacmaobV+SCRW9ijJRdkYpUHmlLvuJGnDPjkvewpbGWJsCabpWEvWdYw3ma8RuHOPj4Jkrdd4VcRaFwox/fPJ7cG6kBydgOBhAACgYBxQIPv9DCsmiMHG1FAxSARX0GcRiELJPJ+MtaStdTrVobNa2jebwc3npLiTvUR4U/CDo1mSZb+Sp/wian8kNZHmGcR6KbtJs9UDsa3V0pbbgpUar4HcxV+NQJBbhn9RGu85g3PDILUrINiUAf26mhPN5Y0paM+HbM68nUf1OLv16OBsjCBrzAJBgNVHRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZpY2F0ZTAdBgNVHQ4EFgQUIHFAEB/3jIIZzJEJ/qdsuI8vN3kwVQYDVR0jBE4wTIAU1e5lU95R2oetQupBbvKv1u5GlAuhMaQvMC0xEjAQBgNVBAoTCUludGVybmV0MjEXMBUGA1UEAxMOY2EuZXhhbXBsZS5vcmeCAQEwDQYJKoZIhvcNAQEFBQADggEBAJt4Q34+pqjW5tHHhkdzTITSBjOOf8EvYMgxTMRzhagLSHTt9RgO5i/G7ELvnwe1j6187m1XD9iEAWKeKbB//ljeOpgnwzkLR9Er5tr1RI3cbil0AX+oX0c1jfRaQnR50Rfb5YoNX6G963iphlxp9C8VLB6eOk/S270XoWoQIkO1ioQ8JY4HE6AyDsOpJaOmHpBaxjgsiko52ZWZeZyaCyL98BXwVxeml7pYnHlXWWidB0N/Zy+LbvWg3urUkiDjMcB6nGImmEfDSxRdybitcMwbwL26z2WOpwL3llm3mcCydKXgXt8IQhfDhOZOHWckeD2tStnJRP/cqBgO62/qirw=";
    private CollectionCredentialResolver credResolver;
    private List<Credential> trustedCredentials;
    private BasicX509Credential signingX509Cred;
    private ExplicitKeySignatureTrustEngine engine;
    private CriteriaSet criteriaSet;
    private String signingEntityID;
    private String rawAlgorithmURI;
    private String rawData;
    private byte[] rawControlSignature;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.signingEntityID = "signing-entity-ID";
        this.signingCert = X509Support.decodeCertificate((String)this.signingCertBase64);
        this.signingPrivateKey = KeySupport.buildJavaRSAPrivateKey((String)this.signingPrivateKeyBase64);
        this.signingX509Cred = new BasicX509Credential(this.signingCert, this.signingPrivateKey);
        this.signingX509Cred.setEntityId(this.signingEntityID);
        this.otherCert1 = X509Support.decodeCertificate((String)this.otherCert1Base64);
        BasicX509Credential otherCred1 = new BasicX509Credential(this.otherCert1);
        otherCred1.setEntityId("other-1");
        this.trustedCredentials = new ArrayList<Credential>();
        this.trustedCredentials.add((Credential)otherCred1);
        this.credResolver = new CollectionCredentialResolver(this.trustedCredentials);
        KeyInfoCredentialResolver kiResolver = XMLSecurityTestingSupport.buildBasicInlineKeyInfoResolver();
        this.engine = new ExplicitKeySignatureTrustEngine((CredentialResolver)this.credResolver, kiResolver);
        this.criteriaSet = new CriteriaSet();
        this.criteriaSet.add((Object)new EntityIdCriterion(this.signingEntityID));
        this.rawData = "Hello, here is some secret data that is to be signed";
        this.rawAlgorithmURI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        this.rawControlSignature = XMLSigningUtil.signWithURI((Credential)this.signingX509Cred, (String)this.rawAlgorithmURI, (byte[])this.rawData.getBytes());
    }

    @Test
    public void testSuccess() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        SignableXMLObject signableXO = this.getValidSignedObject();
        Signature signature = signableXO.getSignature();
        Assert.assertTrue((boolean)this.engine.validate(signature, this.criteriaSet), (String)"Signature was valid and signing cred was trusted");
    }

    @Test
    public void testUntrustedCredential() throws SecurityException {
        SignableXMLObject signableXO = this.getValidSignedObject();
        Signature signature = signableXO.getSignature();
        Assert.assertFalse((boolean)this.engine.validate(signature, this.criteriaSet), (String)"Signature was valid, but signing cred was untrusted");
    }

    @Test
    public void testInvalidSignature() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        SignableXMLObject signableXO = this.getInvalidSignedObject();
        Signature signature = signableXO.getSignature();
        Assert.assertFalse((boolean)this.engine.validate(signature, this.criteriaSet), (String)"Signature was invalid due to document modification");
    }

    @Test
    public void testWhitelistedAlgorithms() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        HashSet<String> algos = new HashSet<String>();
        algos.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        algos.add("http://www.w3.org/2000/09/xmldsig#sha1");
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setWhitelistedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        SignableXMLObject signableXO = this.getValidSignedObject();
        Signature signature = signableXO.getSignature();
        Assert.assertTrue((boolean)this.engine.validate(signature, this.criteriaSet), (String)"Signature was valid with whitelisted algorithms");
    }

    public void testBlacklistedSignatureAlgorithm() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        HashSet<String> algos = new HashSet<String>();
        algos.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setBlacklistedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        SignableXMLObject signableXO = this.getValidSignedObject();
        Signature signature = signableXO.getSignature();
        Assert.assertFalse((boolean)this.engine.validate(signature, this.criteriaSet), (String)"Signature algorithm was blacklisted");
    }

    public void testBlacklistedDigestAlgorithm() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        HashSet<String> algos = new HashSet<String>();
        algos.add("http://www.w3.org/2000/09/xmldsig#sha1");
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setBlacklistedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        SignableXMLObject signableXO = this.getValidSignedObject();
        Signature signature = signableXO.getSignature();
        Assert.assertFalse((boolean)this.engine.validate(signature, this.criteriaSet), (String)"Digest algorithm was blacklisted");
    }

    @Test
    public void testRawSuccess() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        Assert.assertTrue((boolean)this.engine.validate(this.rawControlSignature, this.rawData.getBytes(), this.rawAlgorithmURI, this.criteriaSet, (Credential)this.signingX509Cred), (String)"Raw Signature was valid and supplied candidate signing cred was trusted");
        Assert.assertTrue((boolean)this.engine.validate(this.rawControlSignature, this.rawData.getBytes(), this.rawAlgorithmURI, this.criteriaSet, null), (String)"Raw Signature was valid and non-supplied candidate signing cred was in trusted set");
    }

    @Test
    public void testRawUntrustedCredential() throws SecurityException {
        Assert.assertFalse((boolean)this.engine.validate(this.rawControlSignature, this.rawData.getBytes(), this.rawAlgorithmURI, this.criteriaSet, (Credential)this.signingX509Cred), (String)"Raw Signature was valid, but supplied candidate signing cred was untrusted");
        Assert.assertFalse((boolean)this.engine.validate(this.rawControlSignature, this.rawData.getBytes(), this.rawAlgorithmURI, this.criteriaSet, null), (String)"Raw Signature was valid and the signing cred was not present in trusted set");
    }

    @Test
    public void testRawInvalidSignature() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        String tamperedData = this.rawData + "HAHA All your base are belong to us";
        Assert.assertFalse((boolean)this.engine.validate(this.rawControlSignature, tamperedData.getBytes(), this.rawAlgorithmURI, this.criteriaSet, (Credential)this.signingX509Cred), (String)"Raw Signature was invalid due to data tampering, supplied candidate signing cred was trusted");
    }

    @Test
    public void testRawWhitelistedAlgorithm() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        HashSet<String> algos = new HashSet<String>();
        algos.add(this.rawAlgorithmURI);
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setWhitelistedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        Assert.assertTrue((boolean)this.engine.validate(this.rawControlSignature, this.rawData.getBytes(), this.rawAlgorithmURI, this.criteriaSet, (Credential)this.signingX509Cred), (String)"Raw Signature was valid with whitelisted algorithms");
    }

    @Test
    public void testRawBlacklistedAlgorithm() throws SecurityException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        HashSet<String> algos = new HashSet<String>();
        algos.add(this.rawAlgorithmURI);
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        validationParams.setBlacklistedAlgorithms(algos);
        this.criteriaSet.add((Object)new SignatureValidationParametersCriterion(validationParams));
        Assert.assertFalse((boolean)this.engine.validate(this.rawControlSignature, this.rawData.getBytes(), this.rawAlgorithmURI, this.criteriaSet, (Credential)this.signingX509Cred), (String)"Raw Signature was invalid with blacklisted algorithms");
    }

    protected SignableXMLObject getValidSignedObject() {
        return (SignableSimpleXMLObject)this.unmarshallElement("/data/org/opensaml/xmlsec/signature/support/Signed-SimpleObject.xml");
    }

    protected SignableXMLObject getInvalidSignedObject() {
        return (SignableSimpleXMLObject)this.unmarshallElement("/data/org/opensaml/xmlsec/signature/support/Signed-SimpleObject-InvalidSignature.xml");
    }

    protected SignableXMLObject buildSignedObject() throws SignatureException {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.buildXMLObject(SignableSimpleXMLObject.ELEMENT_NAME);
        sxo.setId("abc123");
        SignableSimpleXMLObject child = (SignableSimpleXMLObject)this.buildXMLObject(SignableSimpleXMLObject.ELEMENT_NAME);
        child.setValue("SomeSimpleValueAsTextContent");
        sxo.getSimpleXMLObjects().add(child);
        Signature signature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        signature.setSigningCredential((Credential)this.signingX509Cred);
        DocumentInternalIDContentReference idContentRef = new DocumentInternalIDContentReference(sxo.getId());
        idContentRef.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        idContentRef.getTransforms().add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        idContentRef.getTransforms().add("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.getContentReferences().add(idContentRef);
        X509KeyInfoGeneratorFactory kiFactory = new X509KeyInfoGeneratorFactory();
        kiFactory.setEmitEntityCertificate(true);
        KeyInfo keyInfo = null;
        try {
            keyInfo = kiFactory.newInstance().generate((Credential)this.signingX509Cred);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Error generating KeyInfo from signing credential: " + (Object)((Object)e)));
        }
        signature.setKeyInfo(keyInfo);
        sxo.setSignature(signature);
        try {
            XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)sxo).marshall((XMLObject)sxo);
        }
        catch (MarshallingException e) {
            Assert.fail((String)("Error marshalling object for signing: " + (Object)((Object)e)));
        }
        Signer.signObject((Signature)signature);
        return sxo;
    }
}

