/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import net.shibboleth.utilities.java.support.testing.TestSupport;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.security.SecurityProviderTestSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.config.GlobalAlgorithmRegistryInitializer;
import org.opensaml.xmlsec.impl.AlgorithmRuntimeSupportedPredicate;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AlgorithmRuntimeSupportedPredicateTest
extends OpenSAMLInitBaseTestCase {
    private AlgorithmRuntimeSupportedPredicate predicate;
    private SecurityProviderTestSupport providerSupport = new SecurityProviderTestSupport();

    @DataProvider
    public Object[][] loadBCTestData() {
        return new Object[][]{{Boolean.FALSE}, {Boolean.TRUE}};
    }

    @BeforeMethod
    public void setUp() {
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        Assert.assertNotNull((Object)registry);
        this.predicate = new AlgorithmRuntimeSupportedPredicate(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="loadBCTestData")
    public void testCommon(boolean loadBC) throws InitializationException {
        AlgorithmRegistry originalRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        Assert.assertNotNull((Object)originalRegistry);
        if (loadBC) {
            this.providerSupport.loadBC();
            new GlobalAlgorithmRegistryInitializer().init();
            this.predicate = new AlgorithmRuntimeSupportedPredicate(AlgorithmSupport.getGlobalAlgorithmRegistry());
        }
        try {
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2000/09/xmldsig#sha1"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#sha256"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#sha384"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#sha512"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
            Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        }
        finally {
            this.providerSupport.unloadBC();
            ConfigurationService.register(AlgorithmRegistry.class, (Object)originalRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="loadBCTestData")
    public void testConditional(boolean loadBC) throws InitializationException {
        AlgorithmRegistry originalRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        Assert.assertNotNull((Object)originalRegistry);
        if (loadBC) {
            this.providerSupport.loadBC();
            new GlobalAlgorithmRegistryInitializer().init();
            this.predicate = new AlgorithmRuntimeSupportedPredicate(AlgorithmSupport.getGlobalAlgorithmRegistry());
        }
        try {
            if (this.providerSupport.haveSunEC() || this.providerSupport.haveBC()) {
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"));
                if (this.providerSupport.haveBC() || TestSupport.isJavaV8OrLater()) {
                    Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"));
                }
            } else {
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"));
            }
            if (this.providerSupport.haveBC() || TestSupport.isJavaV8OrLater()) {
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#sha224"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2009/xmldsig11#dsa-sha256"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2009/xmlenc11#aes128-gcm"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2009/xmlenc11#aes192-gcm"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2009/xmlenc11#rsa-oaep"));
            } else {
                if (this.providerSupport.isOpenJDK()) {
                    Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#sha224"));
                    Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224"));
                    Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224"));
                    Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2009/xmldsig11#dsa-sha256"));
                } else {
                    Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#sha224"));
                    Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224"));
                    Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224"));
                    Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2009/xmldsig11#dsa-sha256"));
                }
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2009/xmlenc11#aes128-gcm"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2009/xmlenc11#aes192-gcm"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2009/xmlenc11#rsa-oaep"));
            }
            if (this.providerSupport.haveBC()) {
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#ripemd160"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160"));
                Assert.assertTrue((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"));
            } else {
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmlenc#ripemd160"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160"));
                Assert.assertFalse((boolean)this.predicate.apply("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"));
            }
        }
        finally {
            this.providerSupport.unloadBC();
            ConfigurationService.register(AlgorithmRegistry.class, (Object)originalRegistry);
        }
    }
}

