/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureValidationConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureValidationParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicSignatureValidationParametersResolverTest {
    private BasicSignatureValidationParametersResolver resolver;
    private CriteriaSet criteriaSet;
    private SignatureValidationConfigurationCriterion criterion;
    private BasicSignatureValidationConfiguration config1;
    private BasicSignatureValidationConfiguration config2;
    private BasicSignatureValidationConfiguration config3;
    private SignatureTrustEngine controlTrustEngine1;
    private SignatureTrustEngine controlTrustEngine2;
    private SignatureTrustEngine controlTrustEngine3;

    @BeforeClass
    public void buildTrustEngines() {
        StaticCredentialResolver credResolver = new StaticCredentialResolver(new ArrayList());
        StaticKeyInfoCredentialResolver keyInfoResolver = new StaticKeyInfoCredentialResolver(new ArrayList());
        this.controlTrustEngine1 = new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, (KeyInfoCredentialResolver)keyInfoResolver);
        this.controlTrustEngine2 = new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, (KeyInfoCredentialResolver)keyInfoResolver);
        this.controlTrustEngine3 = new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, (KeyInfoCredentialResolver)keyInfoResolver);
    }

    @BeforeMethod
    public void setUp() {
        this.resolver = new BasicSignatureValidationParametersResolver();
        this.config1 = new BasicSignatureValidationConfiguration();
        this.config2 = new BasicSignatureValidationConfiguration();
        this.config3 = new BasicSignatureValidationConfiguration();
        this.criterion = new SignatureValidationConfigurationCriterion(new SignatureValidationConfiguration[]{this.config1, this.config2, this.config3});
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.criterion});
    }

    @Test
    public void testResolveSignatureTrustEngine() {
        SignatureTrustEngine trustEngine = this.resolver.resolveSignatureTrustEngine(this.criteriaSet);
        Assert.assertNull((Object)trustEngine);
        this.config1.setSignatureTrustEngine(this.controlTrustEngine1);
        this.config2.setSignatureTrustEngine(this.controlTrustEngine2);
        this.config3.setSignatureTrustEngine(this.controlTrustEngine3);
        trustEngine = this.resolver.resolveSignatureTrustEngine(this.criteriaSet);
        Assert.assertTrue((trustEngine == this.controlTrustEngine1 ? 1 : 0) != 0);
        this.config1.setSignatureTrustEngine(null);
        trustEngine = this.resolver.resolveSignatureTrustEngine(this.criteriaSet);
        Assert.assertTrue((trustEngine == this.controlTrustEngine2 ? 1 : 0) != 0);
        this.config2.setSignatureTrustEngine(null);
        trustEngine = this.resolver.resolveSignatureTrustEngine(this.criteriaSet);
        Assert.assertTrue((trustEngine == this.controlTrustEngine3 ? 1 : 0) != 0);
    }

    @Test
    public void testResolve() throws ResolverException {
        this.config1.setBlacklistedAlgorithms(Arrays.asList("foo", "bar"));
        this.config1.setSignatureTrustEngine(this.controlTrustEngine1);
        Iterable paramsIter = this.resolver.resolve(this.criteriaSet);
        Assert.assertNotNull((Object)paramsIter);
        Iterator iterator = paramsIter.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        SignatureValidationParameters params = (SignatureValidationParameters)iterator.next();
        Assert.assertNotNull((Object)params);
        Assert.assertTrue((params.getSignatureTrustEngine() == this.controlTrustEngine1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)params.getWhitelistedAlgorithms().isEmpty());
        Assert.assertEquals((int)params.getBlacklistedAlgorithms().size(), (int)2);
        Assert.assertTrue((boolean)params.getBlacklistedAlgorithms().contains("foo"));
        Assert.assertTrue((boolean)params.getBlacklistedAlgorithms().contains("bar"));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testResolveSingle() throws ResolverException {
        this.config1.setBlacklistedAlgorithms(Arrays.asList("foo", "bar"));
        this.config1.setSignatureTrustEngine(this.controlTrustEngine1);
        SignatureValidationParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertTrue((params.getSignatureTrustEngine() == this.controlTrustEngine1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)params.getWhitelistedAlgorithms().isEmpty());
        Assert.assertEquals((int)params.getBlacklistedAlgorithms().size(), (int)2);
        Assert.assertTrue((boolean)params.getBlacklistedAlgorithms().contains("foo"));
        Assert.assertTrue((boolean)params.getBlacklistedAlgorithms().contains("bar"));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullCriteriaSet() throws ResolverException {
        this.resolver.resolve(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testAbsentCriterion() throws ResolverException {
        this.resolver.resolve(new CriteriaSet());
    }
}

