/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.encryption.KeyReference;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyReferenceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedURI;
    private int expectedNumUnknownChildren;

    public KeyReferenceTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/KeyReference.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/KeyReferenceChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedURI = "urn:string:foo";
        this.expectedNumUnknownChildren = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        KeyReference ref = (KeyReference)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ref, (String)"KeyReference");
        Assert.assertEquals((String)ref.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertEquals((int)ref.getUnknownXMLObjects().size(), (int)0, (String)"Unknown children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        KeyReference ref = (KeyReference)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)ref, (String)"KeyReference");
        Assert.assertEquals((String)ref.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertEquals((int)ref.getUnknownXMLObjects().size(), (int)this.expectedNumUnknownChildren, (String)"Unknown children");
    }

    @Test
    public void testSingleElementMarshall() {
        KeyReference ref = (KeyReference)this.buildXMLObject(KeyReference.DEFAULT_ELEMENT_NAME);
        ref.setURI(this.expectedURI);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ref);
    }

    @Test
    public void testChildElementsMarshall() {
        KeyReference ref = (KeyReference)this.buildXMLObject(KeyReference.DEFAULT_ELEMENT_NAME);
        ref.setURI(this.expectedURI);
        ref.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        ref.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)ref);
    }
}

