/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.KeyInfoGenerationProfileCriterion;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicEncryptionParametersResolverTest
extends XMLObjectBaseTestCase {
    private BasicEncryptionParametersResolver resolver;
    private CriteriaSet criteriaSet;
    private EncryptionConfigurationCriterion criterion;
    private BasicEncryptionConfiguration config1;
    private BasicEncryptionConfiguration config2;
    private BasicEncryptionConfiguration config3;
    private Credential rsaCred1;
    private Credential aes128Cred1;
    private Credential aes192Cred1;
    private Credential aes256Cred1;
    private String rsaCred1KeyName = "RSACred1";
    private String aes128Cred1KeyName = "AES128Cred1";
    private String aes192Cred1KeyName = "AES192Cred1";
    private String aes256Cred1KeyName = "AES256Cred1";
    private String defaultRSAKeyTransportAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private String defaultAES128DataAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private String defaultAES192DataAlgo = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    private String defaultAES256DataAlgo = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private NamedKeyInfoGeneratorManager defaultKeyTransportKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
    private NamedKeyInfoGeneratorManager defaultDataEncryptionKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();

    @BeforeClass
    public void buildCredentials() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair rsaKeyPair = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        this.rsaCred1 = CredentialSupport.getSimpleCredential((PublicKey)rsaKeyPair.getPublic(), (PrivateKey)rsaKeyPair.getPrivate());
        this.rsaCred1.getKeyNames().add(this.rsaCred1KeyName);
        SecretKey aes128Key = KeySupport.generateKey((String)"AES", (int)128, null);
        this.aes128Cred1 = CredentialSupport.getSimpleCredential((SecretKey)aes128Key);
        this.aes128Cred1.getKeyNames().add(this.aes128Cred1KeyName);
        SecretKey aes192Key = KeySupport.generateKey((String)"AES", (int)192, null);
        this.aes192Cred1 = CredentialSupport.getSimpleCredential((SecretKey)aes192Key);
        this.aes192Cred1.getKeyNames().add(this.aes192Cred1KeyName);
        SecretKey aes256Key = KeySupport.generateKey((String)"AES", (int)256, null);
        this.aes256Cred1 = CredentialSupport.getSimpleCredential((SecretKey)aes256Key);
        this.aes256Cred1.getKeyNames().add(this.aes256Cred1KeyName);
    }

    @BeforeMethod
    public void setUp() {
        this.resolver = new BasicEncryptionParametersResolver();
        this.config1 = new BasicEncryptionConfiguration();
        this.config2 = new BasicEncryptionConfiguration();
        this.config3 = new BasicEncryptionConfiguration();
        this.config3.setDataEncryptionAlgorithms(Arrays.asList(this.defaultAES128DataAlgo, this.defaultAES192DataAlgo, this.defaultAES256DataAlgo, "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2009/xmlenc11#aes128-gcm", "http://www.w3.org/2009/xmlenc11#aes192-gcm", "http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        this.config3.setKeyTransportEncryptionAlgorithms(Arrays.asList(this.defaultRSAKeyTransportAlgo, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
        BasicKeyInfoGeneratorFactory basicFactory1 = new BasicKeyInfoGeneratorFactory();
        X509KeyInfoGeneratorFactory x509Factory1 = new X509KeyInfoGeneratorFactory();
        this.defaultKeyTransportKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
        this.defaultKeyTransportKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)basicFactory1);
        this.defaultKeyTransportKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)x509Factory1);
        this.config3.setKeyTransportKeyInfoGeneratorManager(this.defaultKeyTransportKeyInfoGeneratorManager);
        BasicKeyInfoGeneratorFactory basicFactory2 = new BasicKeyInfoGeneratorFactory();
        X509KeyInfoGeneratorFactory x509Factory2 = new X509KeyInfoGeneratorFactory();
        this.defaultDataEncryptionKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
        this.defaultDataEncryptionKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)basicFactory2);
        this.defaultDataEncryptionKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)x509Factory2);
        this.config3.setDataKeyInfoGeneratorManager(this.defaultDataEncryptionKeyInfoGeneratorManager);
        this.criterion = new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{this.config1, this.config2, this.config3});
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.criterion});
    }

    @Test
    public void testBasicRSA() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential(), (Object)this.rsaCred1);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testRSAWithAlgorithmOverrides() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config2.setDataEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        this.config2.setKeyTransportEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential(), (Object)this.rsaCred1);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testRSAWithBlacklist() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config1.setBlacklistedAlgorithms(Arrays.asList(this.defaultRSAKeyTransportAlgo, this.defaultAES128DataAlgo, this.defaultAES192DataAlgo));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential(), (Object)this.rsaCred1);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES256DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testRSAWithWhitelist() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config1.setWhitelistedAlgorithms(Arrays.asList("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential(), (Object)this.rsaCred1);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testRSAWithGeneratedDataCredential() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.resolver.setAutoGenerateDataEncryptionCredential(true);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential(), (Object)this.rsaCred1);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential().getSecretKey());
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getDataEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testRSAOAEPParameters() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config1.setKeyTransportEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params.getRSAOAEPParameters());
        this.config1.setKeyTransportEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertTrue((boolean)params.getRSAOAEPParameters().isEmpty());
        this.config1.setKeyTransportEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
        this.config3.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2009/xmlenc11#mgf1sha1", "dummy-oaep-params-3"));
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
        Assert.assertEquals((String)params.getRSAOAEPParameters().getMaskGenerationFunction(), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha1");
        Assert.assertEquals((String)params.getRSAOAEPParameters().getOAEPParams(), (String)"dummy-oaep-params-3");
        this.config1.setKeyTransportEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2009/xmlenc11#rsa-oaep"));
        this.config2.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2009/xmlenc11#mgf1sha256", null));
        this.config3.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2009/xmlenc11#mgf1sha1", "dummy-oaep-params-3"));
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((String)params.getRSAOAEPParameters().getMaskGenerationFunction(), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha256");
        Assert.assertEquals((String)params.getRSAOAEPParameters().getOAEPParams(), (String)"dummy-oaep-params-3");
        this.config1.setKeyTransportEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2009/xmlenc11#rsa-oaep"));
        this.config1.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2001/04/xmlenc#sha512", null, null));
        this.config2.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2009/xmlenc11#mgf1sha256", null));
        this.config2.setRSAOAEPParametersMerge(false);
        this.config3.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2009/xmlenc11#mgf1sha1", "dummy-oaep-params-3"));
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((String)params.getRSAOAEPParameters().getMaskGenerationFunction(), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha256");
        Assert.assertNull((Object)params.getRSAOAEPParameters().getOAEPParams());
        this.config1.setKeyTransportEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2009/xmlenc11#rsa-oaep"));
        this.config1.setRSAOAEPParameters(null);
        this.config1.setRSAOAEPParametersMerge(false);
        this.config2.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2009/xmlenc11#mgf1sha256", "dummy-oaep-params2"));
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertTrue((boolean)params.getRSAOAEPParameters().isEmpty());
    }

    @Test
    public void testAES128KeyWrap() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.aes128Cred1));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential(), (Object)this.aes128Cred1);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes128");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testDataCredOnly() throws ResolverException {
        this.config1.setDataEncryptionCredentials(Collections.singletonList(this.aes256Cred1));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertNull((Object)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertEquals((Object)params.getDataEncryptionCredential(), (Object)this.aes256Cred1);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES256DataAlgo);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testKeyTransportCredWithBlacklistAndFallthrough() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Arrays.asList(this.rsaCred1, this.aes256Cred1));
        this.config1.setBlacklistedAlgorithms(Arrays.asList("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://www.w3.org/2009/xmlenc11#rsa-oaep"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential(), (Object)this.aes256Cred1);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testDataCredOnlyWithBlacklistAndFallthrough() throws ResolverException {
        this.config1.setDataEncryptionCredentials(Arrays.asList(this.aes128Cred1, this.aes256Cred1));
        this.config1.setBlacklistedAlgorithms(Arrays.asList("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertNull((Object)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertEquals((Object)params.getDataEncryptionCredential(), (Object)this.aes256Cred1);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES256DataAlgo);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testKeyTransportAlgorithmPredicate() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config1.setKeyTransportEncryptionAlgorithms(Arrays.asList("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
        this.config1.setDataEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        HashMap<String, String> algoMap = new HashMap<String, String>();
        algoMap.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        algoMap.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        MapBasedKeyTransportAlgorithmPredicate predicate = new MapBasedKeyTransportAlgorithmPredicate(algoMap);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        this.config1.setKeyTransportAlgorithmPredicate((KeyTransportAlgorithmPredicate)predicate);
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        this.config1.setDataEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
    }

    @Test
    public void testKeyInfoGenerationProfile() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config1.setDataEncryptionCredentials(Collections.singletonList(this.aes128Cred1));
        this.criteriaSet.add((Object)new KeyInfoGenerationProfileCriterion("testKeyInfoProfile"));
        this.defaultDataEncryptionKeyInfoGeneratorManager.setUseDefaultManager(true);
        this.defaultKeyTransportKeyInfoGeneratorManager.setUseDefaultManager(true);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        this.defaultDataEncryptionKeyInfoGeneratorManager.setUseDefaultManager(false);
        this.defaultKeyTransportKeyInfoGeneratorManager.setUseDefaultManager(false);
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        this.defaultDataEncryptionKeyInfoGeneratorManager.setUseDefaultManager(false);
        this.defaultKeyTransportKeyInfoGeneratorManager.setUseDefaultManager(false);
        this.defaultDataEncryptionKeyInfoGeneratorManager.registerFactory("testKeyInfoProfile", (KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        this.defaultKeyTransportKeyInfoGeneratorManager.registerFactory("testKeyInfoProfile", (KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
    }

    @Test
    public void testResolve() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        Iterable paramsIter = this.resolver.resolve(this.criteriaSet);
        Assert.assertNotNull((Object)paramsIter);
        Iterator iterator = paramsIter.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        EncryptionParameters params = (EncryptionParameters)iterator.next();
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential(), (Object)this.rsaCred1);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNoCredentials() throws ResolverException {
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoKeyTransportAlgorithms() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config3.setKeyTransportEncryptionAlgorithms(new ArrayList());
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoDataEncryptionAlgorithmForResolvedDataCredential() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config1.setDataEncryptionCredentials(Collections.singletonList(this.aes128Cred1));
        this.config3.setDataEncryptionAlgorithms(new ArrayList());
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoDataEncryptionAlgorithmForEncrypterAutoGen() throws ResolverException {
        this.config1.setKeyTransportEncryptionCredentials(Collections.singletonList(this.rsaCred1));
        this.config3.setDataEncryptionAlgorithms(new ArrayList());
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testResolveKeyTransportAlgorithmPredicate() {
        Assert.assertNull((Object)this.resolver.resolveKeyTransportAlgorithmPredicate(this.criteriaSet));
        KeyTransportAlgorithmPredicate predicate = new KeyTransportAlgorithmPredicate(){

            public boolean test(@Nullable KeyTransportAlgorithmPredicate.SelectionInput input) {
                return true;
            }
        };
        this.config2.setKeyTransportAlgorithmPredicate(predicate);
        Assert.assertTrue((this.resolver.resolveKeyTransportAlgorithmPredicate(this.criteriaSet) == predicate ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullCriteriaSet() throws ResolverException {
        this.resolver.resolve(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testAbsentCriterion() throws ResolverException {
        this.resolver.resolve(new CriteriaSet());
    }

    public class MapBasedKeyTransportAlgorithmPredicate
    implements KeyTransportAlgorithmPredicate {
        private Map<String, String> algoMap;

        public MapBasedKeyTransportAlgorithmPredicate(Map<String, String> map) {
            this.algoMap = map;
        }

        public boolean test(@Nullable KeyTransportAlgorithmPredicate.SelectionInput input) {
            return this.algoMap.get(input.getDataEncryptionAlgorithm()).equals(input.getKeyTransportAlgorithm());
        }
    }
}

