/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Arrays;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.xmlsec.impl.BlacklistPredicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BlacklistPredicateTest {
    @Test
    public void testBasic() {
        BlacklistPredicate predicate = new BlacklistPredicate(Arrays.asList("A", "B", "C", "D"));
        Assert.assertFalse((boolean)predicate.test("A"));
        Assert.assertFalse((boolean)predicate.test("B"));
        Assert.assertFalse((boolean)predicate.test("C"));
        Assert.assertFalse((boolean)predicate.test("D"));
        Assert.assertTrue((boolean)predicate.test("X"));
        Assert.assertTrue((boolean)predicate.test("Y"));
        Assert.assertTrue((boolean)predicate.test("Z"));
        Assert.assertTrue((boolean)predicate.test("foo"));
        Assert.assertTrue((boolean)predicate.test("bar"));
        Assert.assertTrue((boolean)predicate.test("bax"));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullSet() {
        new BlacklistPredicate(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullArg() {
        BlacklistPredicate predicate = new BlacklistPredicate(Arrays.asList("A", "B", "C", "D"));
        predicate.test(null);
    }
}

