/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Arrays;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.xmlsec.impl.WhitelistPredicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class WhitelistPredicateTest {
    @Test
    public void testBasic() {
        WhitelistPredicate predicate = new WhitelistPredicate(Arrays.asList("A", "B", "C", "D"));
        Assert.assertTrue((boolean)predicate.test("A"));
        Assert.assertTrue((boolean)predicate.test("B"));
        Assert.assertTrue((boolean)predicate.test("C"));
        Assert.assertTrue((boolean)predicate.test("D"));
        Assert.assertFalse((boolean)predicate.test("X"));
        Assert.assertFalse((boolean)predicate.test("Y"));
        Assert.assertFalse((boolean)predicate.test("Z"));
        Assert.assertFalse((boolean)predicate.test("foo"));
        Assert.assertFalse((boolean)predicate.test("bar"));
        Assert.assertFalse((boolean)predicate.test("bax"));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullSet() {
        new WhitelistPredicate(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullArg() {
        WhitelistPredicate predicate = new WhitelistPredicate(Arrays.asList("A", "B", "C", "D"));
        predicate.test(null);
    }
}

