/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.messaging.impl;

import java.util.Collections;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.messaging.impl.PopulateSignatureValidationParametersHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateSignatureValidationParametersHandlerTest
extends OpenSAMLInitBaseTestCase {
    private MessageContext messageContext;
    private PopulateSignatureValidationParametersHandler handler;

    @BeforeMethod
    public void setUp() {
        this.messageContext = new MessageContext();
        this.handler = new PopulateSignatureValidationParametersHandler();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.handler.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNoContext() throws Exception {
        this.handler.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new MockResolver(false));
        this.handler.initialize();
        this.handler.invoke(null);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testResolverError() throws Exception {
        this.handler.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new MockResolver(true));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testSuccess() throws Exception {
        this.handler.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new MockResolver(false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)((SecurityParametersContext)this.messageContext.getSubcontext(SecurityParametersContext.class)).getSignatureValidationParameters());
    }

    private class MockResolver
    implements SignatureValidationParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        public Iterable<SignatureValidationParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public SignatureValidationParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            Constraint.isNotNull((Object)((SignatureValidationConfigurationCriterion)criteria.get(SignatureValidationConfigurationCriterion.class)), (String)"Criterion was null");
            return new SignatureValidationParameters();
        }
    }
}

