/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.xmlsec.signature.DEREncodedKeyValue;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DEREncodedKeyValueTest
extends XMLObjectProviderBaseTestCase {
    private String expectedID;
    private String expectedStringContent;

    public DEREncodedKeyValueTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/DEREncodedKeyValue.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xmlsec/signature/impl/DEREncodedKeyValueOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "bar";
        this.expectedStringContent = "someDEREncodedKey";
    }

    @Test
    public void testSingleElementUnmarshall() {
        DEREncodedKeyValue der = (DEREncodedKeyValue)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)der, (String)"DEREncodedKeyValue");
        Assert.assertEquals((String)der.getValue(), (String)this.expectedStringContent, (String)"DEREncodedKeyValue value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        DEREncodedKeyValue der = (DEREncodedKeyValue)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)der, (String)"DEREncodedKeyValue");
        Assert.assertEquals((String)this.expectedID, (String)der.getID(), (String)"Id attribute");
        Assert.assertEquals((String)der.getValue(), (String)this.expectedStringContent, (String)"DEREncodedKeyValue value");
        Assert.assertEquals((Object)der.resolveIDFromRoot(this.expectedID), (Object)der);
    }

    @Test
    public void testSingleElementMarshall() {
        DEREncodedKeyValue der = (DEREncodedKeyValue)this.buildXMLObject(DEREncodedKeyValue.DEFAULT_ELEMENT_NAME);
        der.setValue(this.expectedStringContent);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)der);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(DEREncodedKeyValue.DEFAULT_ELEMENT_NAME);
        ((DEREncodedKeyValue)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        DEREncodedKeyValue der = (DEREncodedKeyValue)this.buildXMLObject(DEREncodedKeyValue.DEFAULT_ELEMENT_NAME);
        der.setID(this.expectedID);
        der.setValue(this.expectedStringContent);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)der);
        Assert.assertEquals((Object)der.resolveIDFromRoot(this.expectedID), (Object)der);
    }
}

