/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.xmlsec.signature.ECKeyValue;
import org.opensaml.xmlsec.signature.NamedCurve;
import org.opensaml.xmlsec.signature.PublicKey;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ECKeyValueTest
extends XMLObjectProviderBaseTestCase {
    private String expectedID;

    public ECKeyValueTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/ECKeyValue.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xmlsec/signature/impl/ECKeyValueOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/ECKeyValueChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "bar";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ECKeyValue keyValue = (ECKeyValue)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)keyValue, (String)"ECKeyValue");
        Assert.assertNull((Object)keyValue.getNamedCurve(), (String)"NamedCurve child element");
        Assert.assertNull((Object)keyValue.getPublicKey(), (String)"PublicKey child element");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        ECKeyValue keyValue = (ECKeyValue)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)keyValue, (String)"ECKeyValue");
        Assert.assertEquals((String)this.expectedID, (String)keyValue.getID(), (String)"Id attribute");
        Assert.assertEquals((Object)keyValue.resolveIDFromRoot(this.expectedID), (Object)keyValue);
        Assert.assertNull((Object)keyValue.getNamedCurve(), (String)"NamedCurve child element");
        Assert.assertNull((Object)keyValue.getPublicKey(), (String)"PublicKey child element");
    }

    @Test
    public void testChildElementsUnmarshall() {
        ECKeyValue keyValue = (ECKeyValue)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)keyValue, (String)"ECKeyValue");
        Assert.assertNotNull((Object)keyValue.getNamedCurve(), (String)"NamedCurve child element");
        Assert.assertNotNull((Object)keyValue.getPublicKey(), (String)"PublicKey child element");
    }

    @Test
    public void testSingleElementMarshall() {
        ECKeyValue keyValue = (ECKeyValue)this.buildXMLObject(ECKeyValue.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keyValue);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(ECKeyValue.DEFAULT_ELEMENT_NAME);
        ((ECKeyValue)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        ECKeyValue keyValue = (ECKeyValue)this.buildXMLObject(ECKeyValue.DEFAULT_ELEMENT_NAME);
        keyValue.setID(this.expectedID);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)keyValue);
        Assert.assertEquals((Object)keyValue.resolveIDFromRoot(this.expectedID), (Object)keyValue);
    }

    @Test
    public void testChildElementsMarshall() {
        ECKeyValue keyValue = (ECKeyValue)this.buildXMLObject(ECKeyValue.DEFAULT_ELEMENT_NAME);
        keyValue.setNamedCurve((NamedCurve)this.buildXMLObject(NamedCurve.DEFAULT_ELEMENT_NAME));
        keyValue.setPublicKey((PublicKey)this.buildXMLObject(PublicKey.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)keyValue);
    }
}

