/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xmlsec.signature.RetrievalMethod;
import org.opensaml.xmlsec.signature.Transforms;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RetrievalMethodTest
extends XMLObjectProviderBaseTestCase {
    private String expectedURI;
    private String expectedType;

    public RetrievalMethodTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/RetrievalMethod.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/RetrievalMethodChildElements.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xmlsec/signature/impl/RetrievalMethodOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedURI = "urn:string:foo";
        this.expectedType = "someType";
    }

    @Test
    public void testSingleElementUnmarshall() {
        RetrievalMethod rm = (RetrievalMethod)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)rm, (String)"RetrievalMethod");
        Assert.assertEquals((String)rm.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertNull((Object)rm.getTransforms(), (String)"Transforms child element");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        RetrievalMethod rm = (RetrievalMethod)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)rm, (String)"RetrievalMethod");
        Assert.assertEquals((String)rm.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertEquals((String)rm.getType(), (String)this.expectedType, (String)"Type attribute");
        Assert.assertNull((Object)rm.getTransforms(), (String)"Transforms child element");
    }

    @Test
    public void testChildElementsUnmarshall() {
        RetrievalMethod rm = (RetrievalMethod)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)rm, (String)"RetrievalMethod");
        Assert.assertEquals((String)rm.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertNotNull((Object)rm.getTransforms(), (String)"Transforms child element");
    }

    @Test
    public void testSingleElementMarshall() {
        RetrievalMethod rm = (RetrievalMethod)this.buildXMLObject(RetrievalMethod.DEFAULT_ELEMENT_NAME);
        rm.setURI(this.expectedURI);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)rm);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        RetrievalMethod rm = (RetrievalMethod)this.buildXMLObject(RetrievalMethod.DEFAULT_ELEMENT_NAME);
        rm.setURI(this.expectedURI);
        rm.setType(this.expectedType);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)rm);
    }

    @Test
    public void testChildElementsMarshall() {
        RetrievalMethod rm = (RetrievalMethod)this.buildXMLObject(RetrievalMethod.DEFAULT_ELEMENT_NAME);
        rm.setURI(this.expectedURI);
        rm.setTransforms((Transforms)this.buildXMLObject(Transforms.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)rm);
    }
}

