/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.signature.X509CRL;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.X509IssuerSerial;
import org.opensaml.xmlsec.signature.X509SKI;
import org.opensaml.xmlsec.signature.X509SubjectName;
import org.testng.Assert;
import org.testng.annotations.Test;

public class X509DataTest
extends XMLObjectProviderBaseTestCase {
    public X509DataTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/X509Data.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/X509DataChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        X509Data x509Data = (X509Data)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)x509Data, (String)"X509Data");
        Assert.assertEquals((int)x509Data.getXMLObjects().size(), (int)0, (String)"Total # of XMLObject child elements");
    }

    @Test
    public void testChildElementsUnmarshall() {
        X509Data x509Data = (X509Data)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)x509Data, (String)"X509Data");
        Assert.assertEquals((int)x509Data.getXMLObjects().size(), (int)11, (String)"Total # of XMLObject child elements");
        Assert.assertEquals((int)x509Data.getX509IssuerSerials().size(), (int)1, (String)"# of X509IssuerSerial child elements");
        Assert.assertEquals((int)x509Data.getX509SKIs().size(), (int)1, (String)"# of X509SKI child elements");
        Assert.assertEquals((int)x509Data.getX509SubjectNames().size(), (int)2, (String)"# of X509SubjectName child elements");
        Assert.assertEquals((int)x509Data.getX509Certificates().size(), (int)3, (String)"# of X509Certificate child elements");
        Assert.assertEquals((int)x509Data.getX509CRLs().size(), (int)2, (String)"# of X509CRL child elements");
        Assert.assertEquals((int)x509Data.getXMLObjects(SimpleXMLObject.ELEMENT_NAME).size(), (int)2, (String)"# of SimpleElement child elements");
    }

    @Test
    public void testSingleElementMarshall() {
        X509Data x509Data = (X509Data)this.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)x509Data);
    }

    @Test
    public void testChildElementsMarshall() {
        X509Data x509Data = (X509Data)this.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
        x509Data.getXMLObjects().add(this.buildXMLObject(X509IssuerSerial.DEFAULT_ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(X509SKI.DEFAULT_ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(X509SubjectName.DEFAULT_ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(X509CRL.DEFAULT_ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(X509SubjectName.DEFAULT_ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(X509CRL.DEFAULT_ELEMENT_NAME));
        x509Data.getXMLObjects().add(this.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)x509Data);
    }
}

