/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.shibboleth.utilities.java.support.repository.RepositorySupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObjectBuilder;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.DocumentInternalIDContentReference;
import org.opensaml.xmlsec.signature.support.EnvelopedSignatureTest;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.URIContentReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetachedSignatureTest
extends XMLObjectBaseTestCase {
    private final Logger log = LoggerFactory.getLogger(EnvelopedSignatureTest.class);
    private BasicCredential goodCredential;
    private BasicCredential badCredential;
    private SignableSimpleXMLObjectBuilder sxoBuilder;
    private XMLObjectBuilder<Signature> sigBuilder;
    private BasicParserPool parserPool;
    private String algoURI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";

    @BeforeMethod
    protected void setUp() throws Exception {
        KeyPair keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.goodCredential = CredentialSupport.getSimpleCredential((PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate());
        keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.badCredential = CredentialSupport.getSimpleCredential((PublicKey)keyPair.getPublic(), null);
        this.sxoBuilder = new SignableSimpleXMLObjectBuilder();
        this.sigBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Signature.DEFAULT_ELEMENT_NAME);
        this.parserPool = new BasicParserPool();
        this.parserPool.setNamespaceAware(true);
    }

    @Test
    public void testInternalSignatureAndVerification() throws MarshallingException, UnmarshallingException, SignatureException {
        SignableSimpleXMLObject sxo = this.getXMLObjectWithSignature();
        Signature signature = sxo.getSignature();
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)sxo);
        Element signedElement = marshaller.marshall((XMLObject)sxo);
        Signer.signObject((Signature)signature);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Marshalled deatched Signature: \n" + SerializeSupport.nodeToString((Node)signedElement));
        }
        Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(signedElement);
        sxo = (SignableSimpleXMLObject)unmarshaller.unmarshall(signedElement);
        signature = (Signature)sxo.getOrderedChildren().get(1);
        SignatureValidator.validate((Signature)signature, (Credential)this.goodCredential);
        try {
            SignatureValidator.validate((Signature)signature, (Credential)this.badCredential);
            Assert.fail((String)"Validated signature with improper public key");
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
    }

    @Test
    public void testExternalSignatureAndVerification() throws MarshallingException, SignatureException {
        Signature signature = (Signature)this.sigBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)this.goodCredential);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        String incommonMetadata = RepositorySupport.buildHTTPResourceURL((String)"java-opensaml", (String)"opensaml-xmlsec-impl/src/test/resources/org/opensaml/xmlsec/signature/support/InCommon-metadata.xml", (boolean)false);
        URIContentReference contentReference = new URIContentReference(incommonMetadata);
        contentReference.getTransforms().add("http://www.w3.org/2001/10/xml-exc-c14n#");
        contentReference.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        signature.getContentReferences().add(contentReference);
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)signature);
        Element signatureElement = marshaller.marshall((XMLObject)signature);
        Signer.signObject((Signature)signature);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Marshalled deatched Signature: \n" + SerializeSupport.nodeToString((Node)signatureElement));
        }
        SignatureValidator.validate((Signature)signature, (Credential)this.goodCredential);
    }

    private SignableSimpleXMLObject getXMLObjectWithSignature() {
        SignableSimpleXMLObject rootSXO = this.sxoBuilder.buildObject();
        SignableSimpleXMLObject childSXO = this.sxoBuilder.buildObject();
        childSXO.setId("FOO");
        rootSXO.getSimpleXMLObjects().add(childSXO);
        Signature sig = (Signature)this.sigBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        sig.setSigningCredential((Credential)this.goodCredential);
        sig.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.setSignatureAlgorithm(this.algoURI);
        DocumentInternalIDContentReference contentReference = new DocumentInternalIDContentReference("FOO");
        contentReference.getTransforms().add("http://www.w3.org/2001/10/xml-exc-c14n#");
        contentReference.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        sig.getContentReferences().add(contentReference);
        rootSXO.setSignature(sig);
        return rootSXO;
    }
}

