/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.xmlsec.encryption.EncryptionProperties;
import org.opensaml.xmlsec.encryption.EncryptionProperty;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptionPropertiesTest
extends XMLObjectProviderBaseTestCase {
    private String expectedID;
    private int expectedNumEncProps;

    public EncryptionPropertiesTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/EncryptionProperties.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xmlsec/encryption/impl/EncryptionPropertiesOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/EncryptionPropertiesChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "someID";
        this.expectedNumEncProps = 3;
    }

    @Test
    public void testSingleElementUnmarshall() {
        EncryptionProperties ep = (EncryptionProperties)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ep, (String)"EncryptionProperties");
        Assert.assertNull((Object)ep.getID(), (String)"Id attribute");
        Assert.assertEquals((int)ep.getEncryptionProperties().size(), (int)0, (String)"# of EncryptionProperty children");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        EncryptionProperties ep = (EncryptionProperties)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)ep, (String)"EncryptionProperties");
        Assert.assertEquals((String)ep.getID(), (String)this.expectedID, (String)"Id attribute");
        Assert.assertEquals((int)ep.getEncryptionProperties().size(), (int)0, (String)"# of EncryptionProperty children");
        Assert.assertEquals((Object)ep.resolveID(this.expectedID), (Object)ep, (String)"ID lookup failed");
    }

    @Test
    public void testChildElementsUnmarshall() {
        EncryptionProperties ep = (EncryptionProperties)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)ep, (String)"EncryptionProperties");
        Assert.assertNull((Object)ep.getID(), (String)"Id attribute");
        Assert.assertEquals((int)ep.getEncryptionProperties().size(), (int)this.expectedNumEncProps, (String)"# of EncryptionProperty children");
    }

    @Test
    public void testSingleElementMarshall() {
        EncryptionProperties ep = (EncryptionProperties)this.buildXMLObject(EncryptionProperties.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ep);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(EncryptionProperties.DEFAULT_ELEMENT_NAME);
        ((EncryptionProperties)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        EncryptionProperties ep = (EncryptionProperties)this.buildXMLObject(EncryptionProperties.DEFAULT_ELEMENT_NAME);
        ep.setID(this.expectedID);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ep);
    }

    @Test
    public void testChildElementsMarshall() {
        EncryptionProperties ep = (EncryptionProperties)this.buildXMLObject(EncryptionProperties.DEFAULT_ELEMENT_NAME);
        ep.getEncryptionProperties().add((EncryptionProperty)this.buildXMLObject(EncryptionProperty.DEFAULT_ELEMENT_NAME));
        ep.getEncryptionProperties().add((EncryptionProperty)this.buildXMLObject(EncryptionProperty.DEFAULT_ELEMENT_NAME));
        ep.getEncryptionProperties().add((EncryptionProperty)this.buildXMLObject(EncryptionProperty.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)ep);
    }
}

