/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.encryption.OriginatorKeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.MgmtData;
import org.opensaml.xmlsec.signature.PGPData;
import org.opensaml.xmlsec.signature.RetrievalMethod;
import org.opensaml.xmlsec.signature.SPKIData;
import org.opensaml.xmlsec.signature.X509Data;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OriginatorKeyInfoTest
extends XMLObjectProviderBaseTestCase {
    private String expectedID;

    public OriginatorKeyInfoTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/OriginatorKeyInfo.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xmlsec/encryption/impl/OriginatorKeyInfoOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/OriginatorKeyInfoChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "abc123";
    }

    @Test
    public void testSingleElementUnmarshall() {
        OriginatorKeyInfo keyInfo = (OriginatorKeyInfo)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)keyInfo, (String)"OriginatorKeyInfo");
        Assert.assertNull((Object)keyInfo.getID(), (String)"Id attribute");
        Assert.assertEquals((int)keyInfo.getXMLObjects().size(), (int)0, (String)"Total # of XMLObject child elements");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        OriginatorKeyInfo keyInfo = (OriginatorKeyInfo)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)keyInfo, (String)"OriginatorKeyInfo");
        Assert.assertEquals((String)keyInfo.getID(), (String)this.expectedID, (String)"Id attribute");
        Assert.assertEquals((int)keyInfo.getXMLObjects().size(), (int)0, (String)"Total # of XMLObject child elements");
    }

    @Test
    public void testChildElementsUnmarshall() {
        OriginatorKeyInfo keyInfo = (OriginatorKeyInfo)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)keyInfo, (String)"OriginatorKeyInfo");
        Assert.assertEquals((int)keyInfo.getXMLObjects().size(), (int)11, (String)"Total # of XMLObject child elements");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)2, (String)"# of KeyName child elements");
        Assert.assertEquals((int)keyInfo.getKeyValues().size(), (int)2, (String)"# of KeyValue child elements");
        Assert.assertEquals((int)keyInfo.getRetrievalMethods().size(), (int)1, (String)"# of RetrievalMethod child elements");
        Assert.assertEquals((int)keyInfo.getX509Datas().size(), (int)2, (String)"# of X509Data child elements");
        Assert.assertEquals((int)keyInfo.getPGPDatas().size(), (int)1, (String)"# of PGPData child elements");
        Assert.assertEquals((int)keyInfo.getSPKIDatas().size(), (int)1, (String)"# of SPKIData child elements");
        Assert.assertEquals((int)keyInfo.getMgmtDatas().size(), (int)1, (String)"# of MgmtData child elements");
        Assert.assertEquals((int)keyInfo.getXMLObjects(SimpleXMLObject.ELEMENT_NAME).size(), (int)1, (String)"# of SimpleElement child elements");
    }

    @Test
    public void testSingleElementMarshall() {
        OriginatorKeyInfo keyInfo = (OriginatorKeyInfo)this.buildXMLObject(OriginatorKeyInfo.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keyInfo);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        OriginatorKeyInfo keyInfo = (OriginatorKeyInfo)this.buildXMLObject(OriginatorKeyInfo.DEFAULT_ELEMENT_NAME);
        keyInfo.setID(this.expectedID);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)keyInfo);
    }

    @Test
    public void testChildElementsMarshall() {
        OriginatorKeyInfo keyInfo = (OriginatorKeyInfo)this.buildXMLObject(OriginatorKeyInfo.DEFAULT_ELEMENT_NAME);
        keyInfo.getXMLObjects().add(this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(KeyValue.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(KeyValue.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(RetrievalMethod.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(PGPData.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(SPKIData.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(MgmtData.DEFAULT_ELEMENT_NAME));
        keyInfo.getXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)keyInfo);
    }
}

