/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.xmlsec.encryption.PRF;
import org.opensaml.xmlsec.encryption.Parameters;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PRFTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private String expectedParametersContent;

    public PRFTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/PRF.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/PRFChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "urn:string:foo";
        this.expectedParametersContent = "MyParams";
    }

    @Test
    public void testSingleElementUnmarshall() {
        PRF prf = (PRF)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)prf, (String)"PRF");
        Assert.assertEquals((String)prf.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
    }

    @Test
    public void testChildElementsUnmarshall() {
        PRF prf = (PRF)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)prf, (String)"PRF");
        Assert.assertEquals((String)prf.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)prf.getParameters(), (String)"Parameters child element");
        System.out.println("Parameters: " + prf.getParameters().getClass().getName());
    }

    @Test
    public void testSingleElementMarshall() {
        PRF prf = (PRF)this.buildXMLObject(PRF.DEFAULT_ELEMENT_NAME);
        prf.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)prf);
    }

    @Test
    public void testChildElementsMarshall() {
        PRF prf = (PRF)this.buildXMLObject(PRF.DEFAULT_ELEMENT_NAME);
        prf.setAlgorithm(this.expectedAlgorithm);
        XMLObjectBuilder xsAnyBuilder = builderFactory.getBuilderOrThrow(XSAny.TYPE_NAME);
        XSAny parameters = (XSAny)xsAnyBuilder.buildObject(Parameters.DEFAULT_ELEMENT_NAME);
        parameters.setTextContent(this.expectedParametersContent);
        prf.setParameters((XMLObject)parameters);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)prf);
    }
}

