/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.xmlsec.signature.KeyInfoReference;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyInfoReferenceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedID;
    private String expectedURI;

    public KeyInfoReferenceTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/KeyInfoReference.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xmlsec/signature/impl/KeyInfoReferenceOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "bar";
        this.expectedURI = "#foo";
    }

    public void testSingleElementUnmarshall() {
        KeyInfoReference ref = (KeyInfoReference)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ref, (String)"KeyInfoReference");
        Assert.assertEquals((String)ref.getURI(), (String)this.expectedURI, (String)"URI attribute");
    }

    public void testSingleElementOptionalAttributesUnmarshall() {
        KeyInfoReference ref = (KeyInfoReference)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)ref, (String)"KeyInfoReference");
        Assert.assertEquals((String)ref.getID(), (String)this.expectedID, (String)"Id attribute");
        Assert.assertEquals((String)ref.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertEquals((Object)ref.resolveIDFromRoot(this.expectedID), (Object)ref);
    }

    public void testSingleElementMarshall() {
        KeyInfoReference ref = (KeyInfoReference)this.buildXMLObject(KeyInfoReference.DEFAULT_ELEMENT_NAME);
        ref.setURI(this.expectedURI);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ref);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(KeyInfoReference.DEFAULT_ELEMENT_NAME);
        ((KeyInfoReference)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    public void testSingleElementOptionalAttributesMarshall() {
        KeyInfoReference ref = (KeyInfoReference)this.buildXMLObject(KeyInfoReference.DEFAULT_ELEMENT_NAME);
        ref.setID(this.expectedID);
        ref.setURI(this.expectedURI);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ref);
        Assert.assertEquals((Object)ref.resolveIDFromRoot(this.expectedID), (Object)ref);
    }
}

