/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameter;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.impl.DHWithExplicitKDFKeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.impl.KANonce;
import org.opensaml.xmlsec.agreement.impl.KeySize;
import org.opensaml.xmlsec.agreement.impl.PrivateCredential;
import org.opensaml.xmlsec.derivation.impl.MockKeyDerivation;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DHWithExplicitKDFKeyAgreementProcessorTest
extends OpenSAMLInitBaseTestCase {
    private DHWithExplicitKDFKeyAgreementProcessor processor;

    @BeforeMethod
    public void setUp() {
        this.processor = new DHWithExplicitKDFKeyAgreementProcessor();
    }

    @Test
    public void encryptingCase() throws Exception {
        KeyPair recipientKeyPair = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential recipientCredential = CredentialSupport.getSimpleCredential((PublicKey)recipientKeyPair.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.add((Object)new MockKeyDerivation());
        params.addAll(this.getMockParams());
        KeyAgreementCredential keyAgreementCredential = this.processor.execute((Credential)recipientCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
        Assert.assertNotNull((Object)keyAgreementCredential);
        Assert.assertNotNull((Object)keyAgreementCredential.getSecretKey());
        Assert.assertEquals((String)keyAgreementCredential.getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)keyAgreementCredential.getSecretKey()), (Object)128);
        Assert.assertNull((Object)keyAgreementCredential.getPublicKey());
        Assert.assertNull((Object)keyAgreementCredential.getPrivateKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential().getPublicKey());
        Assert.assertNull((Object)keyAgreementCredential.getRecipientCredential().getPrivateKey());
        Assert.assertNull((Object)keyAgreementCredential.getRecipientCredential().getSecretKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential().getPublicKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential().getPrivateKey());
        Assert.assertNull((Object)keyAgreementCredential.getOriginatorCredential().getSecretKey());
        Assert.assertEquals((String)keyAgreementCredential.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#dh-es");
        Assert.assertEquals((int)keyAgreementCredential.getParameters().size(), (int)2);
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(MockKeyDerivation.class));
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(KANonce.class));
        Assert.assertEquals((String)((KANonce)keyAgreementCredential.getParameters().get(KANonce.class)).getValue(), (String)"AABBCCDD");
    }

    @Test
    public void decryptingCase() throws Exception {
        KeyPair originatorKeyPair = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential originatorCredential = CredentialSupport.getSimpleCredential((PublicKey)originatorKeyPair.getPublic(), null);
        KeyPair recipientKeyPair = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential recipientCredential = CredentialSupport.getSimpleCredential((PublicKey)recipientKeyPair.getPublic(), (PrivateKey)recipientKeyPair.getPrivate());
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.add((Object)new PrivateCredential((Credential)recipientCredential));
        params.add((Object)new MockKeyDerivation());
        params.addAll(this.getMockParams());
        KeyAgreementCredential keyAgreementCredential = this.processor.execute((Credential)originatorCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
        Assert.assertNotNull((Object)keyAgreementCredential);
        Assert.assertNotNull((Object)keyAgreementCredential.getSecretKey());
        Assert.assertEquals((String)keyAgreementCredential.getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)keyAgreementCredential.getSecretKey()), (Object)128);
        Assert.assertNull((Object)keyAgreementCredential.getPublicKey());
        Assert.assertNull((Object)keyAgreementCredential.getPrivateKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential().getPublicKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential().getPrivateKey());
        Assert.assertNull((Object)keyAgreementCredential.getRecipientCredential().getSecretKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential().getPublicKey());
        Assert.assertNull((Object)keyAgreementCredential.getOriginatorCredential().getPrivateKey());
        Assert.assertNull((Object)keyAgreementCredential.getOriginatorCredential().getSecretKey());
        Assert.assertEquals((String)keyAgreementCredential.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#dh-es");
        Assert.assertEquals((int)keyAgreementCredential.getParameters().size(), (int)3);
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(PrivateCredential.class));
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(MockKeyDerivation.class));
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(KANonce.class));
        Assert.assertEquals((String)((KANonce)keyAgreementCredential.getParameters().get(KANonce.class)).getValue(), (String)"AABBCCDD");
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void nonECCred() throws Exception {
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        BasicCredential publicCredential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.add((Object)new MockKeyDerivation());
        params.addAll(this.getMockParams());
        this.processor.execute((Credential)publicCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void keyDerivationError() throws Exception {
        KeyPair kp = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential publicCredential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.add((Object)new MockKeyDerivation());
        params.addAll(this.getMockParams());
        this.processor.execute((Credential)publicCredential, "urn:test:InvalidBlockEncryption", params);
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void missingKeyDerivationParam() throws Exception {
        KeyPair kp = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential publicCredential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.addAll(this.getMockParams());
        this.processor.execute((Credential)publicCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void specifiedKeySizeMismatch() throws Exception {
        KeyPair kp = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential publicCredential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.add((Object)new MockKeyDerivation());
        params.add((Object)new KeySize(Integer.valueOf(256)));
        this.processor.execute((Credential)publicCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
    }

    private Collection<KeyAgreementParameter> getMockParams() {
        ArrayList<KeyAgreementParameter> params = new ArrayList<KeyAgreementParameter>();
        KANonce nonce = new KANonce();
        nonce.setValue("AABBCCDD");
        params.add((KeyAgreementParameter)nonce);
        return params;
    }
}

