/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support.tests;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.encryption.CipherData;
import org.opensaml.xmlsec.encryption.CipherReference;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.DefaultPreDecryptionValidator;
import org.opensaml.xmlsec.encryption.support.PreDecryptionValidationException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultPreDecryptionValidatorTest
extends XMLObjectBaseTestCase {
    private DefaultPreDecryptionValidator validator;
    private EncryptedData encryptedData;
    private EncryptedKey encryptedKey;

    @BeforeMethod
    public void setup() throws Exception {
        this.validator = new DefaultPreDecryptionValidator();
        this.encryptedData = (EncryptedData)XMLObjectSupport.buildXMLObject((QName)EncryptedData.DEFAULT_ELEMENT_NAME);
        this.encryptedData.setCipherData((CipherData)XMLObjectSupport.buildXMLObject((QName)CipherData.DEFAULT_ELEMENT_NAME));
        this.encryptedKey = (EncryptedKey)XMLObjectSupport.buildXMLObject((QName)EncryptedKey.DEFAULT_ELEMENT_NAME);
        this.encryptedKey.setCipherData((CipherData)XMLObjectSupport.buildXMLObject((QName)CipherData.DEFAULT_ELEMENT_NAME));
    }

    @Test
    public void goodEncryptedData() throws Exception {
        this.validator.validate(this.encryptedData);
    }

    @Test
    public void goodEncryptedKey() throws Exception {
        this.validator.validate(this.encryptedKey);
    }

    @Test(expectedExceptions={PreDecryptionValidationException.class})
    public void noCipherData() throws Exception {
        this.encryptedData.setCipherData(null);
        this.validator.validate(this.encryptedData);
    }

    @Test(expectedExceptions={PreDecryptionValidationException.class})
    public void encryptedDataWithCipherReference() throws Exception {
        this.encryptedData.getCipherData().setCipherReference((CipherReference)XMLObjectSupport.buildXMLObject((QName)CipherReference.DEFAULT_ELEMENT_NAME));
        this.validator.validate(this.encryptedData);
    }

    @Test(expectedExceptions={PreDecryptionValidationException.class})
    public void encryptedKeyWithCipherReference() throws Exception {
        this.encryptedKey.getCipherData().setCipherReference((CipherReference)XMLObjectSupport.buildXMLObject((QName)CipherReference.DEFAULT_ELEMENT_NAME));
        this.validator.validate(this.encryptedKey);
    }
}

