/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.cryptacular.util.CertUtil;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NamedKeyInfoGeneratorManagerTest
extends XMLObjectBaseTestCase {
    private NamedKeyInfoGeneratorManager manager;
    private BasicKeyInfoGeneratorFactory basicFactoryFoo;
    private BasicKeyInfoGeneratorFactory basicFactoryFoo2;
    private BasicKeyInfoGeneratorFactory basicFactoryBar;
    private X509KeyInfoGeneratorFactory x509FactoryFoo;
    private X509KeyInfoGeneratorFactory x509FactoryBar;
    private String nameFoo = "FOO";
    private String nameBar = "BAR";
    private String certDER = "/data/certificate.der";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.manager = new NamedKeyInfoGeneratorManager();
        this.basicFactoryFoo = new BasicKeyInfoGeneratorFactory();
        this.basicFactoryFoo2 = new BasicKeyInfoGeneratorFactory();
        this.basicFactoryBar = new BasicKeyInfoGeneratorFactory();
        this.x509FactoryFoo = new X509KeyInfoGeneratorFactory();
        this.x509FactoryBar = new X509KeyInfoGeneratorFactory();
    }

    @Test
    public void testRegister() {
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.basicFactoryFoo);
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.x509FactoryFoo);
        KeyInfoGeneratorManager fooManager = this.manager.getManager(this.nameFoo);
        Assert.assertNotNull((Object)fooManager, (String)"Expected named manager not present/created");
        Assert.assertEquals((int)fooManager.getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        Assert.assertTrue((boolean)fooManager.getFactories().contains(this.basicFactoryFoo), (String)"Expected factory not found");
        Assert.assertTrue((boolean)fooManager.getFactories().contains(this.x509FactoryFoo), (String)"Expected factory not found");
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.basicFactoryFoo2);
        Assert.assertFalse((boolean)fooManager.getFactories().contains(this.basicFactoryFoo), (String)"Unexpected factory found");
        Assert.assertTrue((boolean)fooManager.getFactories().contains(this.basicFactoryFoo2), (String)"Expected factory not found");
    }

    @Test
    public void testDeregister() {
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.basicFactoryFoo);
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.x509FactoryFoo);
        KeyInfoGeneratorManager fooManager = this.manager.getManager(this.nameFoo);
        Assert.assertNotNull((Object)fooManager, (String)"Expected named manager not present/created");
        Assert.assertEquals((int)fooManager.getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        this.manager.deregisterFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.x509FactoryFoo);
        Assert.assertTrue((boolean)fooManager.getFactories().contains(this.basicFactoryFoo), (String)"Expected factory not found");
        Assert.assertFalse((boolean)fooManager.getFactories().contains(this.x509FactoryFoo), (String)"Unexpected factory found");
        try {
            this.manager.deregisterFactory("BAZ", (KeyInfoGeneratorFactory)this.x509FactoryFoo);
            Assert.fail((String)"Use of non-existent manager name should have caused an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetManagerNames() {
        Set names = this.manager.getManagerNames();
        Assert.assertTrue((boolean)names.isEmpty(), (String)"Names was not empty");
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.basicFactoryFoo);
        this.manager.registerFactory(this.nameBar, (KeyInfoGeneratorFactory)this.basicFactoryBar);
        names = this.manager.getManagerNames();
        Assert.assertEquals((int)names.size(), (int)2, (String)"Unexpected # of manager names");
        Assert.assertTrue((boolean)names.contains(this.nameFoo), (String)"Expected manager name not found");
        Assert.assertTrue((boolean)names.contains(this.nameBar), (String)"Expected manager name not found");
        try {
            names.remove(this.basicFactoryFoo);
            Assert.fail((String)"Returned names set should be unmodifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetManagerByName() {
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.basicFactoryFoo);
        this.manager.registerFactory(this.nameBar, (KeyInfoGeneratorFactory)this.basicFactoryBar);
        Set names = this.manager.getManagerNames();
        Assert.assertEquals((int)names.size(), (int)2, (String)"Unexpected # of manager names");
        Assert.assertNotNull((Object)this.manager.getManager(this.nameFoo), (String)"Failed to find manager by name");
        Assert.assertNotNull((Object)this.manager.getManager(this.nameBar), (String)"Failed to find manager by name");
        Assert.assertFalse((boolean)names.contains("BAZ"), (String)"Non-existent manager name found in name set");
        Assert.assertNotNull((Object)this.manager.getManager("BAZ"), (String)"Failed to create new manager");
        Assert.assertTrue((boolean)names.contains("BAZ"), (String)"Expected manager name not found");
    }

    @Test
    public void testRemoveManagerByName() {
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.basicFactoryFoo);
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.x509FactoryFoo);
        this.manager.registerFactory(this.nameBar, (KeyInfoGeneratorFactory)this.basicFactoryBar);
        Set names = this.manager.getManagerNames();
        Assert.assertEquals((int)names.size(), (int)2, (String)"Unexpected # of manager names");
        Assert.assertNotNull((Object)this.manager.getManager(this.nameFoo), (String)"Failed to find manager by name");
        Assert.assertNotNull((Object)this.manager.getManager(this.nameBar), (String)"Failed to find manager by name");
        Assert.assertTrue((boolean)names.contains(this.nameFoo), (String)"Expected manager name not found");
        Assert.assertTrue((boolean)names.contains(this.nameBar), (String)"Expected manager name not found");
        this.manager.removeManager(this.nameFoo);
        Assert.assertEquals((int)names.size(), (int)1, (String)"Unexpected # of manager names");
        Assert.assertNotNull((Object)this.manager.getManager(this.nameBar), (String)"Failed to find manager by name");
        Assert.assertFalse((boolean)names.contains(this.nameFoo), (String)"Unexpected manager name found");
        Assert.assertTrue((boolean)names.contains(this.nameBar), (String)"Expected manager name not found");
    }

    @Test
    public void testRegisterDefaultFactory() {
        KeyInfoGeneratorManager defaultManager = this.manager.getDefaultManager();
        Assert.assertEquals((int)defaultManager.getFactories().size(), (int)0, (String)"Unexpected # of default factories");
        this.manager.registerDefaultFactory((KeyInfoGeneratorFactory)this.basicFactoryFoo);
        this.manager.registerDefaultFactory((KeyInfoGeneratorFactory)this.x509FactoryFoo);
        Assert.assertEquals((int)defaultManager.getFactories().size(), (int)2, (String)"Unexpected # of default factories");
    }

    @Test
    public void testDeregisterDefaultFactory() {
        KeyInfoGeneratorManager defaultManager = this.manager.getDefaultManager();
        Assert.assertEquals((int)defaultManager.getFactories().size(), (int)0, (String)"Unexpected # of default factories");
        this.manager.registerDefaultFactory((KeyInfoGeneratorFactory)this.basicFactoryFoo);
        this.manager.registerDefaultFactory((KeyInfoGeneratorFactory)this.x509FactoryFoo);
        Assert.assertEquals((int)defaultManager.getFactories().size(), (int)2, (String)"Unexpected # of default factories");
        this.manager.deregisterDefaultFactory((KeyInfoGeneratorFactory)this.x509FactoryFoo);
        Assert.assertEquals((int)defaultManager.getFactories().size(), (int)1, (String)"Unexpected # of default factories");
    }

    @Test
    public void testLookupFactory() throws IOException {
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.basicFactoryFoo);
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.x509FactoryFoo);
        this.manager.registerFactory(this.nameBar, (KeyInfoGeneratorFactory)this.basicFactoryBar);
        this.manager.registerFactory(this.nameBar, (KeyInfoGeneratorFactory)this.x509FactoryBar);
        this.manager.getManager("BAZ");
        Assert.assertEquals((int)this.manager.getManager(this.nameFoo).getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        Assert.assertEquals((int)this.manager.getManager(this.nameBar).getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        Assert.assertEquals((int)this.manager.getManager("BAZ").getFactories().size(), (int)0, (String)"Unexpected # of managed factories");
        Assert.assertEquals((int)this.manager.getManagerNames().size(), (int)3, (String)"Unexpected # of manager names");
        X509Certificate cert = CertUtil.readCertificate((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.certDER));
        BasicCredential basicCred = new BasicCredential(cert.getPublicKey());
        BasicX509Credential x509Cred = new BasicX509Credential(cert);
        Assert.assertNotNull((Object)this.manager.getFactory(this.nameFoo, (Credential)basicCred), (String)"Failed to find factory based on manager name and credential");
        Assert.assertTrue((this.basicFactoryFoo == this.manager.getFactory(this.nameFoo, (Credential)basicCred) ? 1 : 0) != 0, (String)"Found incorrect factory based on name and credential");
        Assert.assertNotNull((Object)this.manager.getFactory(this.nameFoo, (Credential)x509Cred), (String)"Failed to find factory based on manager name and credential");
        Assert.assertTrue((this.x509FactoryFoo == this.manager.getFactory(this.nameFoo, (Credential)x509Cred) ? 1 : 0) != 0, (String)"Found incorrect factory based on name and credential");
        Assert.assertNotNull((Object)this.manager.getFactory(this.nameBar, (Credential)x509Cred), (String)"Failed to find factory based on manager name and credential");
        Assert.assertTrue((this.x509FactoryBar == this.manager.getFactory(this.nameBar, (Credential)x509Cred) ? 1 : 0) != 0, (String)"Found incorrect factory based on name and credential");
        Assert.assertNull((Object)this.manager.getFactory("BAZ", (Credential)x509Cred), (String)"Found non-existent factory based on name and credential");
        Assert.assertNull((Object)this.manager.getFactory("ABC123", (Credential)x509Cred));
        X509KeyInfoGeneratorFactory myFactory = new X509KeyInfoGeneratorFactory();
        this.manager.registerDefaultFactory((KeyInfoGeneratorFactory)myFactory);
        Assert.assertNotNull((Object)this.manager.getFactory("ABC123", (Credential)x509Cred));
        Assert.assertTrue((myFactory == this.manager.getFactory("ABC123", (Credential)x509Cred) ? 1 : 0) != 0);
        this.manager.deregisterDefaultFactory((KeyInfoGeneratorFactory)myFactory);
        Assert.assertNull((Object)this.manager.getFactory("ABC123", (Credential)x509Cred));
    }

    @Test
    public void testFallThroughToDefaultManager() throws IOException {
        X509KeyInfoGeneratorFactory defaultX509Factory = new X509KeyInfoGeneratorFactory();
        this.manager.registerDefaultFactory((KeyInfoGeneratorFactory)defaultX509Factory);
        this.manager.registerFactory(this.nameFoo, (KeyInfoGeneratorFactory)this.basicFactoryFoo);
        BasicX509Credential x509Cred = new BasicX509Credential(CertUtil.readCertificate((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.certDER)));
        this.manager.setUseDefaultManager(true);
        Assert.assertNotNull((Object)this.manager.getFactory(this.nameFoo, (Credential)x509Cred), (String)"Failed to find factory based on manager name and credential");
        Assert.assertTrue((defaultX509Factory == this.manager.getFactory(this.nameFoo, (Credential)x509Cred) ? 1 : 0) != 0, (String)"Found incorrect factory based on name and credential");
        this.manager.setUseDefaultManager(false);
        Assert.assertNull((Object)this.manager.getFactory(this.nameFoo, (Credential)x509Cred), (String)"Found factory in default manager even though useDefaultManager option set to false");
    }
}

