/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.testing;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.ECKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;

public final class XMLSecurityTestingSupport {
    private XMLSecurityTestingSupport() {
    }

    public static KeyInfoCredentialResolver buildBasicInlineKeyInfoResolver() {
        return new BasicProviderKeyInfoCredentialResolver(XMLSecurityTestingSupport.getBasicInlineKeyInfoProviders());
    }

    public static List<KeyInfoProvider> getBasicInlineKeyInfoProviders() {
        ArrayList<KeyInfoProvider> providers = new ArrayList<KeyInfoProvider>();
        providers.add((KeyInfoProvider)new RSAKeyValueProvider());
        providers.add((KeyInfoProvider)new DSAKeyValueProvider());
        providers.add((KeyInfoProvider)new ECKeyValueProvider());
        providers.add((KeyInfoProvider)new DEREncodedKeyValueProvider());
        providers.add((KeyInfoProvider)new InlineX509DataProvider());
        return providers;
    }
}

