/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.DocumentInternalIDContentReference;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DecryptionSignedContentTest
extends XMLObjectBaseTestCase {
    private Credential signingCredential;
    private DataEncryptionParameters encParams;
    private KeyInfoCredentialResolver encKeyResolver;
    private String idValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        KeyPair keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.signingCredential = CredentialSupport.getSimpleCredential((PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate());
        String encURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)encURI);
        this.encParams = new DataEncryptionParameters();
        this.encParams.setAlgorithm(encURI);
        this.encParams.setEncryptionCredential(encCred);
        this.encKeyResolver = new StaticKeyInfoCredentialResolver(encCred);
        this.idValue = "IDValueFoo";
    }

    @Test
    public void testDecryptAndVerifySignedElement() throws MarshallingException, UnmarshallingException, EncryptionException, DecryptionException, XMLParserException, IOException, SignatureException {
        Element signedElement = this.getSignedElement();
        XMLObject signedXMLObject = unmarshallerFactory.getUnmarshaller(signedElement).unmarshall(signedElement);
        Assert.assertTrue((boolean)(signedXMLObject instanceof SignableSimpleXMLObject));
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)signedXMLObject;
        Encrypter encrypter = new Encrypter();
        EncryptedData encryptedData = encrypter.encryptElement((XMLObject)sxo, this.encParams);
        File tempfile = File.createTempFile("encdata", ".xml");
        this.printXML((XMLObject)encryptedData, tempfile.getAbsolutePath());
        FileInputStream input = new FileInputStream(tempfile);
        Document document = parserPool.parse((InputStream)input);
        tempfile.delete();
        Element encDataElement = document.getDocumentElement();
        XMLObject encryptedXMLObject = unmarshallerFactory.getUnmarshaller(encDataElement).unmarshall(encDataElement);
        Assert.assertTrue((boolean)(encryptedXMLObject instanceof EncryptedData));
        EncryptedData encryptedData2 = (EncryptedData)encryptedXMLObject;
        Decrypter decrypter = new Decrypter(this.encKeyResolver, null, null);
        XMLObject decryptedXMLObject = decrypter.decryptData(encryptedData2, true);
        Assert.assertTrue((boolean)(decryptedXMLObject instanceof SignableSimpleXMLObject));
        SignableSimpleXMLObject decryptedSXO = (SignableSimpleXMLObject)decryptedXMLObject;
        Signature decryptedSignature = decryptedSXO.getSignature();
        Element resolvedElement = decryptedSignature.getDOM().getOwnerDocument().getElementById(this.idValue);
        Assert.assertNotNull((Object)resolvedElement, (String)"Document getElementById found no element");
        Assert.assertTrue((boolean)decryptedSXO.getDOM().isSameNode(resolvedElement), (String)"Document getElementById found different element");
        SignatureValidator.validate((Signature)decryptedSignature, (Credential)this.signingCredential);
    }

    @Test
    public void testPlainRoundTripSignature() throws MarshallingException, UnmarshallingException, SignatureException {
        Element signedElement = this.getSignedElement();
        XMLObject xmlObject = unmarshallerFactory.getUnmarshaller(signedElement).unmarshall(signedElement);
        Assert.assertTrue((boolean)(xmlObject instanceof SignableSimpleXMLObject));
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)xmlObject;
        try {
            SignatureValidator.validate((Signature)sxo.getSignature(), (Credential)this.signingCredential);
        }
        catch (SignatureException e) {
            Assert.fail((String)("Signature validation failed: " + e));
        }
    }

    private Element getSignedElement() throws MarshallingException, SignatureException {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.buildXMLObject(SignableSimpleXMLObject.ELEMENT_NAME);
        sxo.setId(this.idValue);
        Signature sig = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        sig.setSigningCredential(this.signingCredential);
        sig.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        DocumentInternalIDContentReference contentReference = new DocumentInternalIDContentReference(this.idValue);
        contentReference.getTransforms().add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        contentReference.getTransforms().add("http://www.w3.org/2001/10/xml-exc-c14n#");
        contentReference.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        sig.getContentReferences().add(contentReference);
        sxo.setSignature(sig);
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)sxo);
        Element signedElement = marshaller.marshall((XMLObject)sxo);
        Signer.signObject((Signature)sig);
        return signedElement;
    }
}

