/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Collection;
import org.cryptacular.util.CertUtil;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyInfoGeneratorManagerTest
extends XMLObjectBaseTestCase {
    private KeyInfoGeneratorManager manager;
    private BasicKeyInfoGeneratorFactory basicFactory;
    private BasicKeyInfoGeneratorFactory basicFactory2;
    private X509KeyInfoGeneratorFactory x509Factory;
    private X509KeyInfoGeneratorFactory x509Factory2;
    private String certDER = "/data/certificate.der";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.manager = new KeyInfoGeneratorManager();
        this.basicFactory = new BasicKeyInfoGeneratorFactory();
        this.basicFactory2 = new BasicKeyInfoGeneratorFactory();
        this.x509Factory = new X509KeyInfoGeneratorFactory();
        this.x509Factory2 = new X509KeyInfoGeneratorFactory();
    }

    @Test
    public void testRegister() {
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)0, (String)"Unexpected # of managed factories");
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.basicFactory);
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)1, (String)"Unexpected # of managed factories");
        Assert.assertTrue((boolean)this.manager.getFactories().contains(this.basicFactory), (String)"Expected factory not found");
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.x509Factory);
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        Assert.assertTrue((boolean)this.manager.getFactories().contains(this.x509Factory), (String)"Expected factory not found");
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.basicFactory2);
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        Assert.assertTrue((boolean)this.manager.getFactories().contains(this.basicFactory2), (String)"Expected factory not found");
        Assert.assertFalse((boolean)this.manager.getFactories().contains(this.basicFactory), (String)"Unexpected factory found");
    }

    @Test
    public void testDeregister() {
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)0, (String)"Unexpected # of managed factories");
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.basicFactory);
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.x509Factory);
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        Assert.assertTrue((boolean)this.manager.getFactories().contains(this.basicFactory), (String)"Expected factory not found");
        Assert.assertTrue((boolean)this.manager.getFactories().contains(this.x509Factory), (String)"Expected factory not found");
        this.manager.deregisterFactory((KeyInfoGeneratorFactory)this.x509Factory);
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)1, (String)"Unexpected # of managed factories");
        Assert.assertTrue((boolean)this.manager.getFactories().contains(this.basicFactory), (String)"Expected factory not found");
        Assert.assertFalse((boolean)this.manager.getFactories().contains(this.x509Factory), (String)"Unexpected factory found");
        this.manager.deregisterFactory((KeyInfoGeneratorFactory)this.basicFactory);
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)0, (String)"Unexpected # of managed factories");
        Assert.assertFalse((boolean)this.manager.getFactories().contains(this.basicFactory), (String)"Unexpected factory found");
        Assert.assertFalse((boolean)this.manager.getFactories().contains(this.x509Factory), (String)"Unexpected factory found");
    }

    @Test
    public void testGetFactories() {
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.basicFactory);
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.x509Factory);
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        Collection factories = this.manager.getFactories();
        try {
            factories.remove(this.basicFactory);
            Assert.fail((String)"Returned factory collection should be unmodifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testLookupFactory() throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.basicFactory);
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.x509Factory);
        Assert.assertEquals((int)this.manager.getFactories().size(), (int)2, (String)"Unexpected # of managed factories");
        BasicCredential basicCred = new BasicCredential(KeySupport.generateKey((String)"AES", (int)128, null));
        BasicX509Credential x509Cred = new BasicX509Credential(CertUtil.readCertificate((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.certDER)));
        Assert.assertNotNull((Object)this.manager.getFactory((Credential)basicCred), (String)"Failed to find factory based on credential");
        Assert.assertTrue((this.basicFactory == this.manager.getFactory((Credential)basicCred) ? 1 : 0) != 0, (String)"Found incorrect factory based on credential");
        Assert.assertNotNull((Object)this.manager.getFactory((Credential)x509Cred), (String)"Failed to find factory based on credential");
        Assert.assertTrue((this.x509Factory == this.manager.getFactory((Credential)x509Cred) ? 1 : 0) != 0, (String)"Found incorrect factory based on credential");
        this.manager.registerFactory((KeyInfoGeneratorFactory)this.x509Factory2);
        Assert.assertNotNull((Object)this.manager.getFactory((Credential)x509Cred), (String)"Failed to find factory based on credential");
        Assert.assertTrue((this.x509Factory2 == this.manager.getFactory((Credential)x509Cred) ? 1 : 0) != 0, (String)"Found incorrect factory based on credential");
    }
}

