/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.signature.PGPData;
import org.opensaml.xmlsec.signature.PGPKeyID;
import org.opensaml.xmlsec.signature.PGPKeyPacket;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PGPDataTest
extends XMLObjectProviderBaseTestCase {
    public PGPDataTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/PGPData.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/PGPDataChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        PGPData pgpData = (PGPData)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)pgpData, (String)"PGPData");
        Assert.assertNull((Object)pgpData.getPGPKeyID(), (String)"PGPKeyID child element");
        Assert.assertNull((Object)pgpData.getPGPKeyPacket(), (String)"PGPKeyPacket child element");
        Assert.assertEquals((int)pgpData.getUnknownXMLObjects().size(), (int)0, (String)"# of other XMLObject children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        PGPData pgpData = (PGPData)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)pgpData, (String)"PGPData");
        Assert.assertNotNull((Object)pgpData.getPGPKeyID(), (String)"PGPKeyID child element");
        Assert.assertNotNull((Object)pgpData.getPGPKeyPacket(), (String)"PGPKeyPacket child element");
        Assert.assertEquals((int)pgpData.getUnknownXMLObjects().size(), (int)2, (String)"# of other XMLObject children");
    }

    @Test
    public void testSingleElementMarshall() {
        PGPData pgpData = (PGPData)this.buildXMLObject(PGPData.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)pgpData);
    }

    @Test
    public void testChildElementsMarshall() {
        PGPData pgpData = (PGPData)this.buildXMLObject(PGPData.DEFAULT_ELEMENT_NAME);
        pgpData.setPGPKeyID((PGPKeyID)this.buildXMLObject(PGPKeyID.DEFAULT_ELEMENT_NAME));
        pgpData.setPGPKeyPacket((PGPKeyPacket)this.buildXMLObject(PGPKeyPacket.DEFAULT_ELEMENT_NAME));
        pgpData.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        pgpData.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)pgpData);
    }
}

