/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.agreement.impl.DigestMethod;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DigestMethodTest
extends XMLObjectBaseTestCase {
    @Test
    public void basic() throws ComponentInitializationException {
        DigestMethod digest = new DigestMethod();
        digest.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        digest.initialize();
        Assert.assertEquals((String)digest.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        try {
            digest.setAlgorithm("foo");
            Assert.fail((String)"Modify of initialzied component should have failed");
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        DigestMethod cloned = digest.clone();
        Assert.assertTrue((boolean)cloned.isInitialized());
        Assert.assertEquals((String)cloned.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        XMLObject xmlObject = digest.buildXMLObject();
        Assert.assertNotNull((Object)xmlObject);
        Assert.assertTrue((boolean)org.opensaml.xmlsec.signature.DigestMethod.class.isInstance(xmlObject));
        org.opensaml.xmlsec.signature.DigestMethod xmlDigest = (org.opensaml.xmlsec.signature.DigestMethod)org.opensaml.xmlsec.signature.DigestMethod.class.cast(xmlObject);
        Assert.assertEquals((String)xmlDigest.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
    }

    @Test
    public void fromXMLObject() throws Exception {
        org.opensaml.xmlsec.signature.DigestMethod xmlObject = (org.opensaml.xmlsec.signature.DigestMethod)this.buildXMLObject(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
        xmlObject.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        DigestMethod parameter = DigestMethod.fromXMLObject((org.opensaml.xmlsec.signature.DigestMethod)xmlObject);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isInitialized());
        Assert.assertEquals((String)parameter.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        xmlObject.setAlgorithm(null);
        try {
            DigestMethod.fromXMLObject((org.opensaml.xmlsec.signature.DigestMethod)xmlObject);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void missingValue() throws ComponentInitializationException {
        DigestMethod digest = new DigestMethod();
        digest.initialize();
    }
}

