/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.agreement.impl.KANonce;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KANonceTest
extends XMLObjectBaseTestCase {
    @Test
    public void basic() throws Exception {
        KANonce nonce = new KANonce();
        nonce.setValue("AABBCCDD");
        nonce.initialize();
        Assert.assertEquals((String)nonce.getValue(), (String)"AABBCCDD");
        try {
            nonce.setValue("BBCCDDEE");
            Assert.fail((String)"Modify of initialzied component should have failed");
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        KANonce cloned = nonce.clone();
        Assert.assertTrue((boolean)cloned.isInitialized());
        Assert.assertEquals((String)cloned.getValue(), (String)"AABBCCDD");
        XMLObject xmlObject = nonce.buildXMLObject();
        Assert.assertNotNull((Object)xmlObject);
        Assert.assertTrue((boolean)org.opensaml.xmlsec.encryption.KANonce.class.isInstance(xmlObject));
        org.opensaml.xmlsec.encryption.KANonce xmlNonce = (org.opensaml.xmlsec.encryption.KANonce)org.opensaml.xmlsec.encryption.KANonce.class.cast(xmlObject);
        Assert.assertEquals((String)xmlNonce.getValue(), (String)"AABBCCDD");
    }

    @Test
    public void generatedValue() throws Exception {
        KANonce nonce = new KANonce();
        Assert.assertNull((Object)nonce.getValue());
        nonce.initialize();
        String initValue = nonce.getValue();
        assert (initValue != null);
        Assert.assertEquals((int)Base64Support.decode((String)initValue).length, (int)nonce.getGeneratedLength());
        Assert.assertEquals((String)nonce.getValue(), (String)initValue);
        Assert.assertEquals((String)nonce.getValue(), (String)initValue);
    }

    @Test
    public void generatedLength() throws Exception {
        KANonce nonce = new KANonce();
        nonce.setGeneratedLength(Integer.valueOf(16));
        nonce.initialize();
        String initValue = nonce.getValue();
        assert (initValue != null);
        Assert.assertEquals((int)Base64Support.decode((String)initValue).length, (int)nonce.getGeneratedLength());
    }

    @Test
    public void fromXMLObject() throws Exception {
        org.opensaml.xmlsec.encryption.KANonce xmlObject = (org.opensaml.xmlsec.encryption.KANonce)this.buildXMLObject(org.opensaml.xmlsec.encryption.KANonce.DEFAULT_ELEMENT_NAME);
        xmlObject.setValue("AABBCCDD");
        KANonce parameter = KANonce.fromXMLObject((org.opensaml.xmlsec.encryption.KANonce)xmlObject);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isInitialized());
        Assert.assertEquals((String)parameter.getValue(), (String)"AABBCCDD");
        xmlObject.setValue(null);
        try {
            KANonce.fromXMLObject((org.opensaml.xmlsec.encryption.KANonce)xmlObject);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }
}

