/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.impl.DigestMethod;
import org.opensaml.xmlsec.agreement.impl.KANonce;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParametersParser;
import org.opensaml.xmlsec.agreement.impl.KeySize;
import org.opensaml.xmlsec.derivation.impl.ConcatKDF;
import org.opensaml.xmlsec.derivation.impl.PBKDF2;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.ConcatKDFParams;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.IterationCount;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.encryption.KeyLength;
import org.opensaml.xmlsec.encryption.PBKDF2Params;
import org.opensaml.xmlsec.encryption.PRF;
import org.opensaml.xmlsec.encryption.Salt;
import org.opensaml.xmlsec.encryption.Specified;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KeyAgreementParametersParserTest
extends XMLObjectBaseTestCase {
    @Test
    public void ECDHWithConcatKDF() throws KeyAgreementException {
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        agreementMethod.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        kdm.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDFParams xmlParams = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        xmlParams.setAlgorithmID("00AA");
        xmlParams.setPartyUInfo("00BB");
        xmlParams.setPartyVInfo("00CC");
        xmlParams.setSuppPubInfo("00DD");
        xmlParams.setSuppPrivInfo("00EE");
        org.opensaml.xmlsec.signature.DigestMethod digestMethod = (org.opensaml.xmlsec.signature.DigestMethod)this.buildXMLObject(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
        xmlParams.setDigestMethod(digestMethod);
        kdm.getUnknownXMLObjects().add(xmlParams);
        agreementMethod.getUnknownXMLObjects().add(kdm);
        KeyAgreementParametersParser parser = new KeyAgreementParametersParser();
        KeyAgreementParameters parameters = parser.parse(agreementMethod);
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((int)parameters.size(), (int)1);
        ConcatKDF kdf = (ConcatKDF)parameters.get(ConcatKDF.class);
        assert (kdf != null);
        Assert.assertTrue((boolean)kdf.isInitialized());
        Assert.assertEquals((String)kdf.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((String)kdf.getAlgorithmID(), (String)"AA");
        Assert.assertEquals((String)kdf.getPartyUInfo(), (String)"BB");
        Assert.assertEquals((String)kdf.getPartyVInfo(), (String)"CC");
        Assert.assertEquals((String)kdf.getSuppPubInfo(), (String)"DD");
        Assert.assertEquals((String)kdf.getSuppPrivInfo(), (String)"EE");
    }

    @Test
    public void ECDHWithConcatKDFWithKeySize() throws KeyAgreementException {
        org.opensaml.xmlsec.encryption.KeySize xmlKeySize = (org.opensaml.xmlsec.encryption.KeySize)this.buildXMLObject(org.opensaml.xmlsec.encryption.KeySize.DEFAULT_ELEMENT_NAME);
        xmlKeySize.setValue(Integer.valueOf(80));
        EncryptionMethod em = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        em.setKeySize(xmlKeySize);
        EncryptedData ed = (EncryptedData)this.buildXMLObject(EncryptedData.DEFAULT_ELEMENT_NAME);
        ed.setEncryptionMethod(em);
        KeyInfo keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        ed.setKeyInfo(keyInfo);
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        agreementMethod.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        keyInfo.getAgreementMethods().add(agreementMethod);
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        kdm.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDFParams xmlParams = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        xmlParams.setAlgorithmID("00AA");
        xmlParams.setPartyUInfo("00BB");
        xmlParams.setPartyVInfo("00CC");
        xmlParams.setSuppPubInfo("00DD");
        xmlParams.setSuppPrivInfo("00EE");
        org.opensaml.xmlsec.signature.DigestMethod digestMethod = (org.opensaml.xmlsec.signature.DigestMethod)this.buildXMLObject(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
        xmlParams.setDigestMethod(digestMethod);
        kdm.getUnknownXMLObjects().add(xmlParams);
        agreementMethod.getUnknownXMLObjects().add(kdm);
        KeyAgreementParametersParser parser = new KeyAgreementParametersParser();
        KeyAgreementParameters parameters = parser.parse(agreementMethod);
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((int)parameters.size(), (int)2);
        ConcatKDF kdf = (ConcatKDF)parameters.get(ConcatKDF.class);
        assert (kdf != null);
        Assert.assertTrue((boolean)kdf.isInitialized());
        Assert.assertEquals((String)kdf.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((String)kdf.getAlgorithmID(), (String)"AA");
        Assert.assertEquals((String)kdf.getPartyUInfo(), (String)"BB");
        Assert.assertEquals((String)kdf.getPartyVInfo(), (String)"CC");
        Assert.assertEquals((String)kdf.getSuppPubInfo(), (String)"DD");
        Assert.assertEquals((String)kdf.getSuppPrivInfo(), (String)"EE");
        KeySize keySize = (KeySize)parameters.get(KeySize.class);
        assert (keySize != null);
        Assert.assertEquals((int)keySize.getSize(), (int)80);
    }

    @Test
    public void ECDHWithPBKDF2() throws KeyAgreementException {
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        agreementMethod.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        kdm.setAlgorithm("http://www.w3.org/2009/xmlenc11#pbkdf2");
        PBKDF2Params xmlParams = (PBKDF2Params)this.buildXMLObject(PBKDF2Params.DEFAULT_ELEMENT_NAME);
        IterationCount iterationCount = (IterationCount)this.buildXMLObject(IterationCount.DEFAULT_ELEMENT_NAME);
        iterationCount.setValue(Integer.valueOf(1500));
        xmlParams.setIterationCount(iterationCount);
        KeyLength keyLength = (KeyLength)this.buildXMLObject(KeyLength.DEFAULT_ELEMENT_NAME);
        keyLength.setValue(Integer.valueOf(32));
        xmlParams.setKeyLength(keyLength);
        PRF prf = (PRF)this.buildXMLObject(PRF.DEFAULT_ELEMENT_NAME);
        prf.setAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        xmlParams.setPRF(prf);
        Salt salt = (Salt)this.buildXMLObject(Salt.DEFAULT_ELEMENT_NAME);
        Specified specified = (Specified)this.buildXMLObject(Specified.DEFAULT_ELEMENT_NAME);
        specified.setValue("ABCD");
        salt.setSpecified(specified);
        xmlParams.setSalt(salt);
        kdm.getUnknownXMLObjects().add(xmlParams);
        agreementMethod.getUnknownXMLObjects().add(kdm);
        KeyAgreementParametersParser parser = new KeyAgreementParametersParser();
        KeyAgreementParameters parameters = parser.parse(agreementMethod);
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((int)parameters.size(), (int)1);
        PBKDF2 kdf = (PBKDF2)parameters.get(PBKDF2.class);
        assert (kdf != null);
        Assert.assertTrue((boolean)kdf.isInitialized());
        Assert.assertEquals((Integer)kdf.getIterationCount(), (int)1500);
        Assert.assertEquals((Integer)kdf.getKeyLength(), (int)256);
        Assert.assertEquals((String)kdf.getPRF(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        Assert.assertEquals((String)kdf.getSalt(), (String)"ABCD");
    }

    @Test
    public void DHWithConcatKDF() throws KeyAgreementException {
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        agreementMethod.setAlgorithm("http://www.w3.org/2009/xmlenc11#dh-es");
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        kdm.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDFParams xmlParams = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        xmlParams.setAlgorithmID("00AA");
        xmlParams.setPartyUInfo("00BB");
        xmlParams.setPartyVInfo("00CC");
        xmlParams.setSuppPubInfo("00DD");
        xmlParams.setSuppPrivInfo("00EE");
        org.opensaml.xmlsec.signature.DigestMethod digestMethod = (org.opensaml.xmlsec.signature.DigestMethod)this.buildXMLObject(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
        xmlParams.setDigestMethod(digestMethod);
        kdm.getUnknownXMLObjects().add(xmlParams);
        agreementMethod.getUnknownXMLObjects().add(kdm);
        KeyAgreementParametersParser parser = new KeyAgreementParametersParser();
        KeyAgreementParameters parameters = parser.parse(agreementMethod);
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((int)parameters.size(), (int)1);
        ConcatKDF kdf = (ConcatKDF)parameters.get(ConcatKDF.class);
        assert (kdf != null);
        Assert.assertTrue((boolean)kdf.isInitialized());
        Assert.assertEquals((String)kdf.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((String)kdf.getAlgorithmID(), (String)"AA");
        Assert.assertEquals((String)kdf.getPartyUInfo(), (String)"BB");
        Assert.assertEquals((String)kdf.getPartyVInfo(), (String)"CC");
        Assert.assertEquals((String)kdf.getSuppPubInfo(), (String)"DD");
        Assert.assertEquals((String)kdf.getSuppPrivInfo(), (String)"EE");
    }

    @Test
    public void DHWithLegacyKDF() throws KeyAgreementException {
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        agreementMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#dh");
        org.opensaml.xmlsec.encryption.KANonce xmlNonce = (org.opensaml.xmlsec.encryption.KANonce)this.buildXMLObject(org.opensaml.xmlsec.encryption.KANonce.DEFAULT_ELEMENT_NAME);
        xmlNonce.setValue("ABCD");
        agreementMethod.getUnknownXMLObjects().add(xmlNonce);
        org.opensaml.xmlsec.signature.DigestMethod xmlDigest = (org.opensaml.xmlsec.signature.DigestMethod)this.buildXMLObject(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
        xmlDigest.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
        agreementMethod.getUnknownXMLObjects().add(xmlDigest);
        KeyAgreementParametersParser parser = new KeyAgreementParametersParser();
        KeyAgreementParameters parameters = parser.parse(agreementMethod);
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((int)parameters.size(), (int)2);
        KANonce nonce = (KANonce)parameters.get(KANonce.class);
        assert (nonce != null);
        Assert.assertTrue((boolean)nonce.isInitialized());
        Assert.assertEquals((String)nonce.getValue(), (String)"ABCD");
        Assert.assertTrue((boolean)parameters.contains(KANonce.class));
        DigestMethod digestMethod = (DigestMethod)parameters.get(DigestMethod.class);
        assert (digestMethod != null);
        Assert.assertTrue((boolean)digestMethod.isInitialized());
        Assert.assertEquals((String)digestMethod.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void unknownChildType() throws KeyAgreementException {
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        agreementMethod.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        agreementMethod.getUnknownXMLObjects().add(this.buildXMLObject(simpleXMLObjectQName));
        KeyAgreementParametersParser parser = new KeyAgreementParametersParser();
        parser.parse(agreementMethod);
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void unknownKeyDerivationAlgorithm() throws KeyAgreementException {
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        agreementMethod.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        kdm.setAlgorithm("UNKNOWN");
        agreementMethod.getUnknownXMLObjects().add(kdm);
        KeyAgreementParametersParser parser = new KeyAgreementParametersParser();
        parser.parse(agreementMethod);
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void invalidParamData() throws KeyAgreementException {
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        agreementMethod.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        kdm.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDFParams xmlParams = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        xmlParams.setAlgorithmID("01AA");
        xmlParams.setPartyUInfo("02BB");
        xmlParams.setPartyVInfo("03CC");
        xmlParams.setSuppPubInfo("04DD");
        xmlParams.setSuppPrivInfo("05EE");
        org.opensaml.xmlsec.signature.DigestMethod digestMethod = (org.opensaml.xmlsec.signature.DigestMethod)this.buildXMLObject(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
        xmlParams.setDigestMethod(digestMethod);
        kdm.getUnknownXMLObjects().add(xmlParams);
        agreementMethod.getUnknownXMLObjects().add(kdm);
        KeyAgreementParametersParser parser = new KeyAgreementParametersParser();
        parser.parse(agreementMethod);
    }
}

