/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.agreement.impl.PrivateCredential;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PrivateCredentialTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void basic() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPair kp = KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), null);
        PrivateCredential privateCredential = new PrivateCredential((Credential)CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate()));
        Assert.assertNotNull((Object)privateCredential.getCredential());
        try {
            privateCredential = new PrivateCredential((Credential)CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null));
            Assert.fail((String)"PrivateCredential accepted Credential without PrivateKey");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

