/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.tests;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.agreement.impl.ECDHKeyAgreementProcessor;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.KeySize;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KeyAgreementSupportTest
extends XMLObjectBaseTestCase {
    @Test
    public void getGlobalProcessorRegistry() throws Exception {
        Assert.assertNotNull((Object)KeyAgreementSupport.getGlobalProcessorRegistry());
    }

    @Test
    public void getProcessor() throws Exception {
        Assert.assertNotNull((Object)KeyAgreementSupport.getProcessor((String)"http://www.w3.org/2009/xmlenc11#ECDH-ES"));
        Assert.assertTrue((boolean)ECDHKeyAgreementProcessor.class.isInstance(KeyAgreementSupport.getProcessor((String)"http://www.w3.org/2009/xmlenc11#ECDH-ES")));
    }

    @Test
    public void getExplicitKeySize() throws Exception {
        AgreementMethod agreementMethod = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        Assert.assertNull((Object)KeyAgreementSupport.getExplicitKeySize((AgreementMethod)agreementMethod));
        KeyInfo keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        keyInfo.getAgreementMethods().add(agreementMethod);
        Assert.assertNull((Object)KeyAgreementSupport.getExplicitKeySize((AgreementMethod)agreementMethod));
        EncryptedData encryptedData = (EncryptedData)this.buildXMLObject(EncryptedData.DEFAULT_ELEMENT_NAME);
        encryptedData.setKeyInfo(keyInfo);
        Assert.assertNull((Object)KeyAgreementSupport.getExplicitKeySize((AgreementMethod)agreementMethod));
        EncryptionMethod encryptionMethod = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        encryptedData.setEncryptionMethod(encryptionMethod);
        Assert.assertNull((Object)KeyAgreementSupport.getExplicitKeySize((AgreementMethod)agreementMethod));
        KeySize keySize = (KeySize)this.buildXMLObject(KeySize.DEFAULT_ELEMENT_NAME);
        keySize.setValue(Integer.valueOf(128));
        encryptionMethod.setKeySize(keySize);
        Assert.assertEquals((Integer)KeyAgreementSupport.getExplicitKeySize((AgreementMethod)agreementMethod), (Integer)128);
    }

    @Test
    public void supportsKeyAgreement() throws Exception {
        KeyPair ecKeyPair = KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), null);
        Assert.assertTrue((boolean)KeyAgreementSupport.supportsKeyAgreement((Credential)CredentialSupport.getSimpleCredential((PublicKey)ecKeyPair.getPublic(), null)));
        Assert.assertFalse((boolean)KeyAgreementSupport.supportsKeyAgreement((Credential)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2009/xmlenc11#rsa-oaep", (int)2048, (boolean)false)));
        Assert.assertFalse((boolean)KeyAgreementSupport.supportsKeyAgreement((Credential)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2009/xmldsig11#dsa-sha256", (int)1024, (boolean)false)));
    }

    @Test
    public void validateKeyAlgorithmAndSize() throws Exception {
        KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm", null);
        KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm", (Integer)128);
        KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc", null);
        KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc", (Integer)192);
        KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128", null);
        KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128", (Integer)128);
        KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"SomeAlgo", (Integer)128);
        try {
            KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (Integer)256);
            Assert.fail((String)"Should have failed mismatched specified length");
        }
        catch (KeyAgreementException keyAgreementException) {
            // empty catch block
        }
        try {
            KeyAgreementSupport.validateKeyAlgorithmAndSize((String)"SomeAlgo", null);
            Assert.fail((String)"Should have failed non-length URI and null specified length");
        }
        catch (KeyAgreementException keyAgreementException) {
            // empty catch block
        }
    }
}

