/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.algorithm.tests;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashSet;
import javax.crypto.SecretKey;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES128CBC;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES128GCM;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES192CBC;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES192GCM;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES256CBC;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES256GCM;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionDESede;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA256;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA1;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA224;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA256;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA384;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA512;
import org.opensaml.xmlsec.algorithm.descriptors.KeyTransportRSA15;
import org.opensaml.xmlsec.algorithm.descriptors.KeyTransportRSAOAEP;
import org.opensaml.xmlsec.algorithm.descriptors.KeyTransportRSAOAEPMGF1P;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureDSASHA1;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureDSASHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA1;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA224;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA384;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA512;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA1;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA224;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA384;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA512;
import org.opensaml.xmlsec.algorithm.descriptors.SymmetricKeyWrapAES128;
import org.opensaml.xmlsec.algorithm.descriptors.SymmetricKeyWrapAES192;
import org.opensaml.xmlsec.algorithm.descriptors.SymmetricKeyWrapAES256;
import org.opensaml.xmlsec.algorithm.descriptors.SymmetricKeyWrapDESede;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AlgorithmSupportTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void testIsKeyTransportAlgorithm() {
        Assert.assertTrue((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new KeyTransportRSA15()));
        Assert.assertTrue((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new KeyTransportRSAOAEP()));
        Assert.assertTrue((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new KeyTransportRSAOAEPMGF1P()));
        Assert.assertTrue((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new SymmetricKeyWrapAES128()));
        Assert.assertTrue((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new SymmetricKeyWrapAES192()));
        Assert.assertTrue((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new SymmetricKeyWrapAES256()));
        Assert.assertTrue((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new SymmetricKeyWrapDESede()));
        Assert.assertFalse((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new BlockEncryptionAES128CBC()));
        Assert.assertFalse((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new SignatureRSASHA256()));
        Assert.assertFalse((boolean)AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)new DigestSHA256()));
    }

    @Test
    public void testIsDataEncryptionAlgorithm() {
        Assert.assertTrue((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new BlockEncryptionAES128CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new BlockEncryptionAES128GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new BlockEncryptionAES192CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new BlockEncryptionAES192GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new BlockEncryptionAES256CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new BlockEncryptionAES256GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new BlockEncryptionDESede()));
        Assert.assertFalse((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new KeyTransportRSA15()));
        Assert.assertFalse((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new SymmetricKeyWrapAES128()));
        Assert.assertFalse((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new SignatureRSASHA256()));
        Assert.assertFalse((boolean)AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)new DigestSHA256()));
    }

    @Test
    public void testIsSymmetricKeyWrap() {
        Assert.assertTrue((boolean)AlgorithmSupport.isSymmetricKeyWrap((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128"));
        Assert.assertTrue((boolean)AlgorithmSupport.isSymmetricKeyWrap((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192"));
        Assert.assertTrue((boolean)AlgorithmSupport.isSymmetricKeyWrap((String)"http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        Assert.assertTrue((boolean)AlgorithmSupport.isSymmetricKeyWrap((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
        Assert.assertFalse((boolean)AlgorithmSupport.isSymmetricKeyWrap((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        Assert.assertFalse((boolean)AlgorithmSupport.isSymmetricKeyWrap((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        Assert.assertFalse((boolean)AlgorithmSupport.isSymmetricKeyWrap((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertFalse((boolean)AlgorithmSupport.isSymmetricKeyWrap((String)"http://www.w3.org/2001/04/xmlenc#sha256"));
    }

    @Test
    public void testIsBlockEncryption() {
        Assert.assertTrue((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        Assert.assertTrue((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        Assert.assertTrue((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
        Assert.assertTrue((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2009/xmlenc11#aes192-gcm"));
        Assert.assertTrue((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        Assert.assertTrue((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        Assert.assertTrue((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        Assert.assertFalse((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        Assert.assertFalse((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128"));
        Assert.assertFalse((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertFalse((boolean)AlgorithmSupport.isBlockEncryption((String)"http://www.w3.org/2001/04/xmldsig-more#sha224"));
    }

    @Test
    public void testCredentialSupportsAlgorithmForSigning() throws NoSuchAlgorithmException, KeyException, NoSuchProviderException {
        BasicCredential credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"DESede", (int)168, null));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA512()));
        credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"AES", (int)128, null));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA512()));
        credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"AES", (int)192, null));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA512()));
        credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"AES", (int)256, null));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA512()));
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        credential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA512()));
        kp = KeySupport.generateKeyPair((String)"RSA", (int)4096, null);
        credential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA512()));
        kp = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        credential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureDSASHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureDSASHA256()));
        try {
            kp = KeySupport.generateKeyPair((String)"EC", (int)256, null);
            credential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
            Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureECDSASHA1()));
            Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureECDSASHA224()));
            Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureECDSASHA256()));
            Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureECDSASHA384()));
            Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureECDSASHA512()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        kp = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        credential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureECDSASHA1()));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA256()));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new HMACSHA512()));
        credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"AES", (int)256, null));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureECDSASHA1()));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)new SignatureRSASHA256()));
    }

    @Test
    public void testCredentialSupportsAlgorithmForEncryption() throws NoSuchAlgorithmException, NoSuchProviderException {
        BasicCredential credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"DESede", (int)168, null));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionDESede()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new SymmetricKeyWrapDESede()));
        credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"AES", (int)128, null));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionAES128CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionAES128GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new SymmetricKeyWrapAES128()));
        credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"AES", (int)192, null));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionAES192CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionAES192GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new SymmetricKeyWrapAES192()));
        credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"AES", (int)256, null));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionAES256CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionAES256GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new SymmetricKeyWrapAES256()));
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        credential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new KeyTransportRSA15()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new KeyTransportRSAOAEP()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new KeyTransportRSAOAEPMGF1P()));
        kp = KeySupport.generateKeyPair((String)"RSA", (int)4096, null);
        credential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new KeyTransportRSA15()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new KeyTransportRSAOAEP()));
        Assert.assertTrue((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new KeyTransportRSAOAEPMGF1P()));
        kp = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        credential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new KeyTransportRSA15()));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new SymmetricKeyWrapAES128()));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionAES128CBC()));
        credential = CredentialSupport.getSimpleCredential((SecretKey)KeySupport.generateKey((String)"AES", (int)256, null));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new KeyTransportRSA15()));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new SymmetricKeyWrapAES128()));
        Assert.assertFalse((boolean)AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)new BlockEncryptionAES128CBC()));
    }

    @Test
    public void testCheckKeyAlgorithmAndLength() throws NoSuchAlgorithmException, NoSuchProviderException {
        Key key = KeySupport.generateKey((String)"DESede", (int)168, null);
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionDESede()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SymmetricKeyWrapDESede()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA512()));
        key = KeySupport.generateKey((String)"AES", (int)128, null);
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionAES128CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionAES128GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SymmetricKeyWrapAES128()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA512()));
        key = KeySupport.generateKey((String)"AES", (int)192, null);
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionAES192CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionAES192GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SymmetricKeyWrapAES192()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA512()));
        key = KeySupport.generateKey((String)"AES", (int)256, null);
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionAES256CBC()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionAES256GCM()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SymmetricKeyWrapAES256()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new HMACSHA512()));
        key = KeySupport.generateKeyPair((String)"RSA", (int)2048, null).getPrivate();
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new KeyTransportRSA15()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new KeyTransportRSAOAEP()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new KeyTransportRSAOAEPMGF1P()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureRSASHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureRSASHA224()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureRSASHA256()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureRSASHA384()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureRSASHA512()));
        key = KeySupport.generateKeyPair((String)"DSA", (int)1024, null).getPrivate();
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureDSASHA1()));
        Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureDSASHA256()));
        try {
            key = KeySupport.generateKeyPair((String)"EC", (int)256, null).getPrivate();
            Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureECDSASHA1()));
            Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureECDSASHA224()));
            Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureECDSASHA256()));
            Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureECDSASHA384()));
            Assert.assertTrue((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureECDSASHA512()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        key = KeySupport.generateKey((String)"AES", (int)128, null);
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionDESede()));
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionAES192CBC()));
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SymmetricKeyWrapAES256()));
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureRSASHA1()));
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new KeyTransportRSA15()));
        key = KeySupport.generateKeyPair((String)"RSA", (int)2048, null).getPrivate();
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new BlockEncryptionAES192CBC()));
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SymmetricKeyWrapAES256()));
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureDSASHA1()));
        Assert.assertFalse((boolean)AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)new SignatureECDSASHA256()));
    }

    @Test
    public void testGetKeyAlgorithm() {
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128"), (String)"AES");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192"), (String)"AES");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmlenc#kw-aes256"), (String)"AES");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes"), (String)"DESede");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm"), (String)"AES");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2009/xmlenc11#aes192-gcm"), (String)"AES");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2009/xmlenc11#aes256-gcm"), (String)"AES");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha224"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-md5"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"), (String)"RSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2000/09/xmldsig#dsa-sha1"), (String)"DSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2009/xmldsig11#dsa-sha256"), (String)"DSA");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"), (String)"EC");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"), (String)"EC");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"), (String)"EC");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"), (String)"EC");
        Assert.assertEquals((String)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"), (String)"EC");
        Assert.assertNull((Object)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2000/09/xmldsig#hmac-sha1"));
        Assert.assertNull((Object)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha224"));
        Assert.assertNull((Object)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha256"));
        Assert.assertNull((Object)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha384"));
        Assert.assertNull((Object)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha512"));
        Assert.assertNull((Object)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#hmac-md5"));
        Assert.assertNull((Object)AlgorithmSupport.getKeyAlgorithm((String)"http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160"));
    }

    @Test
    public void testValidateAlgorithmURI() {
        String targetURI = "urn:test:target";
        HashSet<String> whiteList = new HashSet<String>();
        HashSet<String> blackList = new HashSet<String>();
        Assert.assertTrue((boolean)AlgorithmSupport.validateAlgorithmURI((String)targetURI, null, null));
        Assert.assertTrue((boolean)AlgorithmSupport.validateAlgorithmURI((String)targetURI, whiteList, null));
        Assert.assertTrue((boolean)AlgorithmSupport.validateAlgorithmURI((String)targetURI, null, blackList));
        Assert.assertTrue((boolean)AlgorithmSupport.validateAlgorithmURI((String)targetURI, whiteList, blackList));
        whiteList.add("urn:test:target");
        Assert.assertTrue((boolean)AlgorithmSupport.validateAlgorithmURI((String)targetURI, whiteList, blackList));
        whiteList.clear();
        blackList.add("urn:test:NOTtarget");
        Assert.assertTrue((boolean)AlgorithmSupport.validateAlgorithmURI((String)targetURI, whiteList, blackList));
        blackList.clear();
        whiteList.add("urn:test:NOTtarget");
        Assert.assertFalse((boolean)AlgorithmSupport.validateAlgorithmURI((String)targetURI, whiteList, blackList));
        whiteList.clear();
    }

    @Test
    public void testGenerateSymmetricKey() throws NoSuchAlgorithmException, KeyException {
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2009/xmlenc11#aes192-gcm"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKey((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
    }

    @Test
    public void testGenerateSymmetricKeyAndCredential() throws NoSuchAlgorithmException, KeyException {
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2009/xmlenc11#aes192-gcm"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        Assert.assertNotNull((Object)AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
    }

    @Test
    public void testGenerateKeyPairWithLength() throws NoSuchAlgorithmException, NoSuchProviderException {
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (int)2048));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2009/xmlenc11#rsa-oaep", (int)2048));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (int)2048));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (int)2048));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (int)2048));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", (int)256));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", (int)256));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", (int)256));
    }

    @Test
    public void testGenerateKeyPairAndCredentialWithLength() throws NoSuchAlgorithmException, NoSuchProviderException {
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (int)2048, (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2009/xmlenc11#rsa-oaep", (int)2048, (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (int)2048, (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (int)2048, (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (int)2048, (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", (int)256, (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", (int)256, (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", (int)256, (boolean)true));
    }

    @Test
    public void testGenerateKeyPairWithParamSpec() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4)));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2009/xmlenc11#rsa-oaep", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4)));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4)));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4)));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4)));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1")));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1")));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPair((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1")));
    }

    @Test
    public void testGenerateKeyPairAndCredentialWithParamSpec() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4), (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2009/xmlenc11#rsa-oaep", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4), (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4), (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4), (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4), (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), (boolean)true));
        Assert.assertNotNull((Object)AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), (boolean)true));
    }
}

