/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.config.impl;

import java.util.Set;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessorRegistry;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.agreement.impl.DHWithExplicitKDFKeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.impl.DHWithLegacyKDFKeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.impl.ECDHKeyAgreementProcessor;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GlobalKeyAgreementProcessorRegistryTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void basic() {
        KeyAgreementProcessorRegistry registry = KeyAgreementSupport.getGlobalProcessorRegistry();
        assert (registry != null);
        Assert.assertEquals((int)registry.getRegisteredAlgorithms().size(), (int)3);
        Assert.assertEquals((Set)registry.getRegisteredAlgorithms(), (Set)CollectionSupport.setOf((Object[])new String[]{"http://www.w3.org/2009/xmlenc11#ECDH-ES", "http://www.w3.org/2001/04/xmlenc#dh", "http://www.w3.org/2009/xmlenc11#dh-es"}));
        Assert.assertNotNull((Object)registry.getProcessor("http://www.w3.org/2009/xmlenc11#ECDH-ES"));
        Assert.assertTrue((boolean)ECDHKeyAgreementProcessor.class.isInstance(registry.getProcessor("http://www.w3.org/2009/xmlenc11#ECDH-ES")));
        Assert.assertNotNull((Object)registry.getProcessor("http://www.w3.org/2001/04/xmlenc#dh"));
        Assert.assertTrue((boolean)DHWithLegacyKDFKeyAgreementProcessor.class.isInstance(registry.getProcessor("http://www.w3.org/2001/04/xmlenc#dh")));
        Assert.assertNotNull((Object)registry.getProcessor("http://www.w3.org/2009/xmlenc11#dh-es"));
        Assert.assertTrue((boolean)DHWithExplicitKDFKeyAgreementProcessor.class.isInstance(registry.getProcessor("http://www.w3.org/2009/xmlenc11#dh-es")));
    }
}

