/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation.impl;

import javax.crypto.SecretKey;
import net.shibboleth.shared.codec.Base64Support;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.xmlsec.derivation.KeyDerivationException;
import org.opensaml.xmlsec.derivation.impl.DHLegacyKDF;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DHLegacyKDFTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void specTestVector() throws Exception {
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        kdf.setNonce("Zm9v");
        String nonce = kdf.getNonce();
        assert (nonce != null);
        byte[] digestCounter1 = kdf.digest(1, "SHA-1", Hex.decodeHex((String)"DEADBEEF"), "Example:Block/Alg", Integer.valueOf(80), Base64Support.decode((String)nonce));
        Assert.assertEquals((byte[])digestCounter1, (byte[])Hex.decodeHex((String)"59D9BA5E06072C1194091952B01B8360534AB11E"));
        byte[] derived = kdf.deriveBytes(Hex.decodeHex((String)"DEADBEEF"), "Example:Block/Alg", Integer.valueOf(80));
        Assert.assertEquals((int)(derived.length * 8), (int)80);
    }

    @Test
    public void basic() throws Exception {
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        kdf.setNonce("Zm9v");
        SecretKey secretKey = null;
        secretKey = kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes128-cbc", null);
        Assert.assertNotNull((Object)secretKey);
        Assert.assertEquals((int)(secretKey.getEncoded().length * 8), (int)128);
        secretKey = kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes128-cbc", Integer.valueOf(128));
        Assert.assertNotNull((Object)secretKey);
        Assert.assertEquals((int)(secretKey.getEncoded().length * 8), (int)128);
        secretKey = kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes192-cbc", null);
        Assert.assertNotNull((Object)secretKey);
        Assert.assertEquals((int)(secretKey.getEncoded().length * 8), (int)192);
        secretKey = kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes192-cbc", Integer.valueOf(192));
        Assert.assertNotNull((Object)secretKey);
        Assert.assertEquals((int)(secretKey.getEncoded().length * 8), (int)192);
        secretKey = kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes256-cbc", null);
        Assert.assertNotNull((Object)secretKey);
        Assert.assertEquals((int)(secretKey.getEncoded().length * 8), (int)256);
        secretKey = kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes256-cbc", Integer.valueOf(256));
        Assert.assertNotNull((Object)secretKey);
        Assert.assertEquals((int)(secretKey.getEncoded().length * 8), (int)256);
    }

    @Test
    public void missingNonce() throws Exception {
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        SecretKey secretKey = null;
        secretKey = kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes128-cbc", null);
        Assert.assertNotNull((Object)secretKey);
        Assert.assertEquals((int)(secretKey.getEncoded().length * 8), (int)128);
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void missingDigest() throws Exception {
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setNonce("Zm9v");
        kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes128-cbc", null);
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void unknownKeyAlgorithm() throws Exception {
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        kdf.setNonce("Zm9v");
        kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "urn:test:invalid", null);
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void unknownDigestAlgorithm() throws Exception {
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setDigestMethod("urn:test:invalid");
        kdf.setNonce("Zm9v");
        kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes128-cbc", Integer.valueOf(128));
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void keyLengthMismatch() throws Exception {
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        kdf.setNonce("Zm9v");
        kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes128-cbc", Integer.valueOf(256));
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void invalidNonce() throws Exception {
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        kdf.setNonce("INVALID!!!!@@$$##");
        kdf.derive(Hex.decodeHex((String)"DEADBEEF"), "http://www.w3.org/2001/04/xmlenc#aes128-cbc", Integer.valueOf(128));
    }
}

