/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.derivation.KeyDerivation;
import org.opensaml.xmlsec.derivation.KeyDerivationException;

public class MockKeyDerivation
implements KeyDerivation {
    @Nonnull
    public String getAlgorithm() {
        return "urn:test:MockKeyDerivation";
    }

    @Nonnull
    public SecretKey derive(@Nonnull byte[] secret, @Nonnull String keyAlgorithm, @Nullable Integer keyLength) throws KeyDerivationException {
        try {
            String algo = AlgorithmSupport.getKeyAlgorithm((String)keyAlgorithm);
            assert (algo != null);
            Integer length = AlgorithmSupport.getKeyLength((String)keyAlgorithm);
            assert (length != null);
            return KeySupport.generateKey((String)algo, (int)length, null);
        }
        catch (Exception e) {
            throw new KeyDerivationException("Error generating mock derived key", (Throwable)e);
        }
    }
}

