/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.KANonce;
import org.opensaml.xmlsec.encryption.OriginatorKeyInfo;
import org.opensaml.xmlsec.encryption.RecipientKeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AgreementMethodTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private int expectedNumUnknownChildren;

    public AgreementMethodTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/AgreementMethod.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/AgreementMethodChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "urn:string:foo";
        this.expectedNumUnknownChildren = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        AgreementMethod am = (AgreementMethod)this.unmarshallElement(this.singleElementFile);
        assert (am != null);
        Assert.assertEquals((String)am.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertNull((Object)am.getKANonce(), (String)"KA-Nonce child element");
        Assert.assertEquals((int)am.getUnknownXMLObjects().size(), (int)0, (String)"Unknown children");
        Assert.assertNull((Object)am.getOriginatorKeyInfo(), (String)"OriginatorKeyInfo child element");
        Assert.assertNull((Object)am.getRecipientKeyInfo(), (String)"RecipientKeyInfo child element");
    }

    @Test
    public void testChildElementsUnmarshall() {
        AgreementMethod am = (AgreementMethod)this.unmarshallElement(this.childElementsFile);
        assert (am != null);
        Assert.assertEquals((String)am.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)am.getKANonce(), (String)"KA-Nonce child element");
        Assert.assertEquals((int)am.getUnknownXMLObjects().size(), (int)this.expectedNumUnknownChildren, (String)"Unknown children");
        Assert.assertNotNull((Object)am.getOriginatorKeyInfo(), (String)"OriginatorKeyInfo child element");
        Assert.assertNotNull((Object)am.getRecipientKeyInfo(), (String)"RecipientKeyInfo child element");
    }

    @Test
    public void testSingleElementMarshall() {
        AgreementMethod am = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        am.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)am);
    }

    @Test
    public void testChildElementsMarshall() {
        AgreementMethod am = (AgreementMethod)this.buildXMLObject(AgreementMethod.DEFAULT_ELEMENT_NAME);
        am.setAlgorithm(this.expectedAlgorithm);
        am.setKANonce((KANonce)this.buildXMLObject(KANonce.DEFAULT_ELEMENT_NAME));
        am.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        am.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        am.setOriginatorKeyInfo((OriginatorKeyInfo)this.buildXMLObject(OriginatorKeyInfo.DEFAULT_ELEMENT_NAME));
        am.setRecipientKeyInfo((RecipientKeyInfo)this.buildXMLObject(RecipientKeyInfo.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)am);
    }
}

