/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.xmlsec.encryption.ConcatKDFParams;
import org.opensaml.xmlsec.signature.DigestMethod;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConcatKDFParamsTest
extends XMLObjectProviderBaseTestCase {
    private String expectedDigestMethod;
    private String expectedAlgorithmID;
    private String expectedPartyUInfo;
    private String expectedPartyVInfo;
    private String expectedSuppPubInfo;
    private String expectedSuppPrivInfo;

    public ConcatKDFParamsTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/ConcatKDFParams.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/ConcatKDFParamsChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedDigestMethod = "urn:string:foo";
        this.expectedAlgorithmID = "00AA";
        this.expectedPartyUInfo = "00BB";
        this.expectedPartyVInfo = "00CC";
        this.expectedSuppPubInfo = "00DD";
        this.expectedSuppPrivInfo = "00EE";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ConcatKDFParams params = (ConcatKDFParams)this.unmarshallElement(this.singleElementFile);
        assert (params != null);
        Assert.assertEquals((String)params.getAlgorithmID(), (String)this.expectedAlgorithmID);
        Assert.assertEquals((String)params.getPartyVInfo(), (String)this.expectedPartyVInfo);
        Assert.assertEquals((String)params.getPartyUInfo(), (String)this.expectedPartyUInfo);
        Assert.assertEquals((String)params.getSuppPubInfo(), (String)this.expectedSuppPubInfo);
        Assert.assertEquals((String)params.getSuppPrivInfo(), (String)this.expectedSuppPrivInfo);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ConcatKDFParams params = (ConcatKDFParams)this.unmarshallElement(this.childElementsFile);
        assert (params != null);
        Assert.assertEquals((String)params.getAlgorithmID(), (String)this.expectedAlgorithmID);
        Assert.assertEquals((String)params.getPartyVInfo(), (String)this.expectedPartyVInfo);
        Assert.assertEquals((String)params.getPartyUInfo(), (String)this.expectedPartyUInfo);
        Assert.assertEquals((String)params.getSuppPubInfo(), (String)this.expectedSuppPubInfo);
        Assert.assertEquals((String)params.getSuppPrivInfo(), (String)this.expectedSuppPrivInfo);
        DigestMethod method = params.getDigestMethod();
        assert (method != null);
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.expectedDigestMethod);
    }

    @Test
    public void testSingleElementMarshall() {
        ConcatKDFParams params = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        params.setAlgorithmID(this.expectedAlgorithmID);
        params.setPartyUInfo(this.expectedPartyUInfo);
        params.setPartyVInfo(this.expectedPartyVInfo);
        params.setSuppPubInfo(this.expectedSuppPubInfo);
        params.setSuppPrivInfo(this.expectedSuppPrivInfo);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)params);
    }

    @Test
    public void testChildElementsMarshall() {
        ConcatKDFParams params = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        params.setAlgorithmID(this.expectedAlgorithmID);
        params.setPartyUInfo(this.expectedPartyUInfo);
        params.setPartyVInfo(this.expectedPartyVInfo);
        params.setSuppPubInfo(this.expectedSuppPubInfo);
        params.setSuppPrivInfo(this.expectedSuppPrivInfo);
        DigestMethod dm = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        dm.setAlgorithm(this.expectedDigestMethod);
        params.setDigestMethod(dm);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)params);
    }

    @Test
    public void testStringBytesConversions() {
        ConcatKDFParams params = null;
        params = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        params.setAlgorithmID(this.expectedAlgorithmID);
        Assert.assertEquals((byte[])params.getAlgorithmIDBytes(), (byte[])new byte[]{0, -86});
        params.setAlgorithmID(null);
        Assert.assertNull((Object)params.getAlgorithmIDBytes());
        params.setAlgorithmIDBytes(new byte[]{0, -86});
        Assert.assertEquals((String)params.getAlgorithmID(), (String)this.expectedAlgorithmID);
        params.setAlgorithmIDBytes(null);
        Assert.assertNull((Object)params.getAlgorithmID());
        try {
            params.setAlgorithmID("FOO");
            params.getAlgorithmIDBytes();
            Assert.fail((String)"Invalid hexBinary value, auto-decoding should have failed");
        }
        catch (XMLRuntimeException xMLRuntimeException) {
            // empty catch block
        }
        params = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        params.setPartyUInfo(this.expectedPartyUInfo);
        Assert.assertEquals((byte[])params.getPartyUInfoBytes(), (byte[])new byte[]{0, -69});
        params.setPartyUInfo(null);
        Assert.assertNull((Object)params.getPartyUInfoBytes());
        params.setPartyUInfoBytes(new byte[]{0, -69});
        Assert.assertEquals((String)params.getPartyUInfo(), (String)this.expectedPartyUInfo);
        params.setPartyUInfoBytes(null);
        Assert.assertNull((Object)params.getPartyUInfo());
        try {
            params.setPartyUInfo("FOO");
            params.getPartyUInfoBytes();
            Assert.fail((String)"Invalid hexBinary value, auto-decoding should have failed");
        }
        catch (XMLRuntimeException xMLRuntimeException) {
            // empty catch block
        }
        params = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        params.setPartyVInfo(this.expectedPartyVInfo);
        Assert.assertEquals((byte[])params.getPartyVInfoBytes(), (byte[])new byte[]{0, -52});
        params.setPartyVInfo(null);
        Assert.assertNull((Object)params.getPartyVInfoBytes());
        params.setPartyVInfoBytes(new byte[]{0, -52});
        Assert.assertEquals((String)params.getPartyVInfo(), (String)this.expectedPartyVInfo);
        params.setPartyVInfoBytes(null);
        Assert.assertNull((Object)params.getPartyVInfo());
        try {
            params.setPartyVInfo("FOO");
            params.getPartyVInfoBytes();
            Assert.fail((String)"Invalid hexBinary value, auto-decoding should have failed");
        }
        catch (XMLRuntimeException xMLRuntimeException) {
            // empty catch block
        }
        params = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        params.setSuppPubInfo(this.expectedSuppPubInfo);
        Assert.assertEquals((byte[])params.getSuppPubInfoBytes(), (byte[])new byte[]{0, -35});
        params.setSuppPubInfo(null);
        Assert.assertNull((Object)params.getSuppPubInfoBytes());
        params.setSuppPubInfoBytes(new byte[]{0, -35});
        Assert.assertEquals((String)params.getSuppPubInfo(), (String)this.expectedSuppPubInfo);
        params.setSuppPubInfoBytes(null);
        Assert.assertNull((Object)params.getSuppPubInfo());
        try {
            params.setSuppPubInfo("FOO");
            params.getSuppPubInfoBytes();
            Assert.fail((String)"Invalid hexBinary value, auto-decoding should have failed");
        }
        catch (XMLRuntimeException xMLRuntimeException) {
            // empty catch block
        }
        params = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        params.setSuppPrivInfo(this.expectedSuppPrivInfo);
        Assert.assertEquals((byte[])params.getSuppPrivInfoBytes(), (byte[])new byte[]{0, -18});
        params.setSuppPrivInfo(null);
        Assert.assertNull((Object)params.getSuppPrivInfoBytes());
        params.setSuppPrivInfoBytes(new byte[]{0, -18});
        Assert.assertEquals((String)params.getSuppPrivInfo(), (String)this.expectedSuppPrivInfo);
        params.setSuppPrivInfoBytes(null);
        Assert.assertNull((Object)params.getSuppPrivInfo());
        try {
            params.setSuppPrivInfo("FOO");
            params.getSuppPrivInfoBytes();
            Assert.fail((String)"Invalid hexBinary value, auto-decoding should have failed");
        }
        catch (XMLRuntimeException xMLRuntimeException) {
            // empty catch block
        }
    }
}

