/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.encryption.DHKeyValue;
import org.opensaml.xmlsec.encryption.Generator;
import org.opensaml.xmlsec.encryption.P;
import org.opensaml.xmlsec.encryption.PgenCounter;
import org.opensaml.xmlsec.encryption.Public;
import org.opensaml.xmlsec.encryption.Q;
import org.opensaml.xmlsec.encryption.Seed;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DHKeyValueTest
extends XMLObjectProviderBaseTestCase {
    public DHKeyValueTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/DHKeyValue.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/DHKeyValueChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
    }

    @Test
    public void testSingleElementUnmarshall() {
        DHKeyValue keyValue = (DHKeyValue)this.unmarshallElement(this.singleElementFile);
        assert (keyValue != null);
        Assert.assertNull((Object)keyValue.getP(), (String)"P child element");
        Assert.assertNull((Object)keyValue.getQ(), (String)"Q child element");
        Assert.assertNull((Object)keyValue.getGenerator(), (String)"Generator child element");
        Assert.assertNull((Object)keyValue.getPublic(), (String)"Public child element");
        Assert.assertNull((Object)keyValue.getSeed(), (String)"seed element");
        Assert.assertNull((Object)keyValue.getPgenCounter(), (String)"pgenCounter element");
    }

    @Test
    public void testChildElementsUnmarshall() {
        DHKeyValue keyValue = (DHKeyValue)this.unmarshallElement(this.childElementsFile);
        assert (keyValue != null);
        Assert.assertNotNull((Object)keyValue.getP(), (String)"P child element");
        Assert.assertNotNull((Object)keyValue.getQ(), (String)"Q child element");
        Assert.assertNotNull((Object)keyValue.getGenerator(), (String)"Generator child element");
        Assert.assertNotNull((Object)keyValue.getPublic(), (String)"Public child element");
        Assert.assertNotNull((Object)keyValue.getSeed(), (String)"seed element");
        Assert.assertNotNull((Object)keyValue.getPgenCounter(), (String)"pgenCounter element");
    }

    @Test
    public void testSingleElementMarshall() {
        DHKeyValue keyValue = (DHKeyValue)this.buildXMLObject(DHKeyValue.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keyValue);
    }

    @Test
    public void testChildElementsMarshall() {
        DHKeyValue keyValue = (DHKeyValue)this.buildXMLObject(DHKeyValue.DEFAULT_ELEMENT_NAME);
        keyValue.setP((P)this.buildXMLObject(P.DEFAULT_ELEMENT_NAME));
        keyValue.setQ((Q)this.buildXMLObject(Q.DEFAULT_ELEMENT_NAME));
        keyValue.setGenerator((Generator)this.buildXMLObject(Generator.DEFAULT_ELEMENT_NAME));
        keyValue.setPublic((Public)this.buildXMLObject(Public.DEFAULT_ELEMENT_NAME));
        keyValue.setSeed((Seed)this.buildXMLObject(Seed.DEFAULT_ELEMENT_NAME));
        keyValue.setPgenCounter((PgenCounter)this.buildXMLObject(PgenCounter.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)keyValue);
    }
}

