/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.encryption.DataReference;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DataReferenceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedURI;
    private int expectedNumUnknownChildren;

    public DataReferenceTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/DataReference.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/DataReferenceChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedURI = "urn:string:foo";
        this.expectedNumUnknownChildren = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        DataReference ref = (DataReference)this.unmarshallElement(this.singleElementFile);
        assert (ref != null);
        Assert.assertEquals((String)ref.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertEquals((int)ref.getUnknownXMLObjects().size(), (int)0, (String)"Unknown children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        DataReference ref = (DataReference)this.unmarshallElement(this.childElementsFile);
        assert (ref != null);
        Assert.assertEquals((String)ref.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertEquals((int)ref.getUnknownXMLObjects().size(), (int)this.expectedNumUnknownChildren, (String)"Unknown children");
    }

    @Test
    public void testSingleElementMarshall() {
        DataReference ref = (DataReference)this.buildXMLObject(DataReference.DEFAULT_ELEMENT_NAME);
        ref.setURI(this.expectedURI);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ref);
    }

    @Test
    public void testChildElementsMarshall() {
        DataReference ref = (DataReference)this.buildXMLObject(DataReference.DEFAULT_ELEMENT_NAME);
        ref.setURI(this.expectedURI);
        ref.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        ref.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)ref);
    }
}

