/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.encryption.DerivedKey;
import org.opensaml.xmlsec.encryption.DerivedKeyName;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.encryption.MasterKeyName;
import org.opensaml.xmlsec.encryption.ReferenceList;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DerivedKeyTest
extends XMLObjectProviderBaseTestCase {
    private String expectedId;
    private String expectedRecipient;
    private String expectedType;

    public DerivedKeyTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/DerivedKey.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xmlsec/encryption/impl/DerivedKeyOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/DerivedKeyChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedId = "abc123";
        this.expectedRecipient = "theRecipient";
        this.expectedType = "urn:string:foo";
    }

    @Test
    public void testSingleElementUnmarshall() {
        DerivedKey dk = (DerivedKey)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)dk);
    }

    @Test
    public void testChildElementsUnmarshall() {
        DerivedKey dk = (DerivedKey)this.unmarshallElement(this.childElementsFile);
        assert (dk != null);
        Assert.assertNotNull((Object)dk.getKeyDerivationMethod());
        Assert.assertNotNull((Object)dk.getReferenceList());
        Assert.assertNotNull((Object)dk.getDerivedKeyName());
        Assert.assertNotNull((Object)dk.getMasterKeyName());
        Assert.assertNotNull((Object)dk);
    }

    public void testSingleElementOptionalAttributesUnmarshall() {
        DerivedKey dk = (DerivedKey)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        assert (dk != null);
        Assert.assertEquals((String)dk.getId(), (String)this.expectedId);
        Assert.assertEquals((String)dk.getRecipient(), (String)this.expectedRecipient);
        Assert.assertEquals((String)dk.getType(), (String)this.expectedType);
    }

    @Test
    public void testSingleElementMarshall() {
        DerivedKey dk = (DerivedKey)this.buildXMLObject(DerivedKey.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)dk);
    }

    @Test
    public void testChildElementsMarshall() {
        DerivedKey dk = (DerivedKey)this.buildXMLObject(DerivedKey.DEFAULT_ELEMENT_NAME);
        dk.setKeyDerivationMethod((KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME));
        dk.setReferenceList((ReferenceList)this.buildXMLObject(ReferenceList.DEFAULT_ELEMENT_NAME));
        dk.setDerivedKeyName((DerivedKeyName)this.buildXMLObject(DerivedKeyName.DEFAULT_ELEMENT_NAME));
        dk.setMasterKeyName((MasterKeyName)this.buildXMLObject(MasterKeyName.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)dk);
    }

    public void testSingleElementOptionalAttributesMarshall() {
        DerivedKey dk = (DerivedKey)this.buildXMLObject(DerivedKey.DEFAULT_ELEMENT_NAME);
        dk.setId(this.expectedId);
        dk.setRecipient(this.expectedRecipient);
        dk.setType(this.expectedType);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)dk);
    }
}

