/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyDerivationMethodTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private int expectedNumUnknownChildren;

    public KeyDerivationMethodTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/KeyDerivationMethod.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/KeyDerivationMethodChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "urn:string:foo";
        this.expectedNumUnknownChildren = 3;
    }

    @Test
    public void testSingleElementUnmarshall() {
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.unmarshallElement(this.singleElementFile);
        assert (kdm != null);
        Assert.assertEquals((String)kdm.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertEquals((int)kdm.getUnknownXMLObjects().size(), (int)0, (String)"Unknown children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.unmarshallElement(this.childElementsFile);
        assert (kdm != null);
        Assert.assertEquals((String)kdm.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertEquals((int)kdm.getUnknownXMLObjects().size(), (int)this.expectedNumUnknownChildren, (String)"Unknown children");
    }

    @Test
    public void testSingleElementMarshall() {
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        kdm.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)kdm);
    }

    @Test
    public void testChildElementsMarshall() {
        KeyDerivationMethod kdm = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        kdm.setAlgorithm(this.expectedAlgorithm);
        kdm.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        kdm.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        kdm.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)kdm);
    }
}

