/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.xmlsec.encryption.OtherSource;
import org.opensaml.xmlsec.encryption.Parameters;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OtherSourceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private String expectedParametersContent;

    public OtherSourceTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/OtherSource.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/OtherSourceChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "urn:string:foo";
        this.expectedParametersContent = "MyParams";
    }

    @Test
    public void testSingleElementUnmarshall() {
        OtherSource otherSource = (OtherSource)this.unmarshallElement(this.singleElementFile);
        assert (otherSource != null);
        Assert.assertEquals((String)otherSource.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
    }

    @Test
    public void testChildElementsUnmarshall() {
        OtherSource otherSource = (OtherSource)this.unmarshallElement(this.childElementsFile);
        assert (otherSource != null);
        Assert.assertEquals((String)otherSource.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)otherSource.getParameters(), (String)"Parameters child element");
    }

    @Test
    public void testSingleElementMarshall() {
        OtherSource otherSource = (OtherSource)this.buildXMLObject(OtherSource.DEFAULT_ELEMENT_NAME);
        otherSource.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)otherSource);
    }

    @Test
    public void testChildElementsMarshall() {
        OtherSource otherSource = (OtherSource)this.buildXMLObject(OtherSource.DEFAULT_ELEMENT_NAME);
        otherSource.setAlgorithm(this.expectedAlgorithm);
        XMLObjectBuilder xsAnyBuilder = builderFactory.ensureBuilder(XSAny.TYPE_NAME);
        XSAny parameters = (XSAny)xsAnyBuilder.buildObject(Parameters.DEFAULT_ELEMENT_NAME);
        parameters.setTextContent(this.expectedParametersContent);
        otherSource.setParameters((XMLObject)parameters);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)otherSource);
    }
}

