/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.encryption.IterationCount;
import org.opensaml.xmlsec.encryption.KeyLength;
import org.opensaml.xmlsec.encryption.PBKDF2Params;
import org.opensaml.xmlsec.encryption.PRF;
import org.opensaml.xmlsec.encryption.Salt;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PBKDF2ParamsTest
extends XMLObjectProviderBaseTestCase {
    public PBKDF2ParamsTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/PBKDF2Params.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/PBKDF2ParamsChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        PBKDF2Params params = (PBKDF2Params)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)params, (String)"PBKDF2Params");
    }

    @Test
    public void testChildElementsUnmarshall() {
        PBKDF2Params params = (PBKDF2Params)this.unmarshallElement(this.childElementsFile);
        assert (params != null);
        Assert.assertNotNull((Object)params.getSalt());
        Assert.assertNotNull((Object)params.getIterationCount());
        Assert.assertNotNull((Object)params.getKeyLength());
        Assert.assertNotNull((Object)params.getPRF());
    }

    @Test
    public void testSingleElementMarshall() {
        PBKDF2Params params = (PBKDF2Params)this.buildXMLObject(PBKDF2Params.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)params);
    }

    @Test
    public void testChildElementsMarshall() {
        PBKDF2Params params = (PBKDF2Params)this.buildXMLObject(PBKDF2Params.DEFAULT_ELEMENT_NAME);
        params.setSalt((Salt)this.buildXMLObject(Salt.DEFAULT_ELEMENT_NAME));
        params.setIterationCount((IterationCount)this.buildXMLObject(IterationCount.DEFAULT_ELEMENT_NAME));
        params.setKeyLength((KeyLength)this.buildXMLObject(KeyLength.DEFAULT_ELEMENT_NAME));
        params.setPRF((PRF)this.buildXMLObject(PRF.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)params);
    }
}

