/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.encryption.DataReference;
import org.opensaml.xmlsec.encryption.KeyReference;
import org.opensaml.xmlsec.encryption.ReferenceList;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReferenceListTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumDataRefs;
    private int expectedNumKeyRefs;

    public ReferenceListTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/ReferenceList.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/ReferenceListChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedNumDataRefs = 2;
        this.expectedNumKeyRefs = 1;
    }

    @Test
    public void testSingleElementUnmarshall() {
        ReferenceList rl = (ReferenceList)this.unmarshallElement(this.singleElementFile);
        assert (rl != null);
        Assert.assertEquals((int)rl.getDataReferences().size(), (int)0, (String)"# of DataReference children");
        Assert.assertEquals((int)rl.getKeyReferences().size(), (int)0, (String)"# of KeyReference children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        ReferenceList rl = (ReferenceList)this.unmarshallElement(this.childElementsFile);
        assert (rl != null);
        Assert.assertEquals((int)rl.getDataReferences().size(), (int)this.expectedNumDataRefs, (String)"# of DataReference children");
        Assert.assertEquals((int)rl.getKeyReferences().size(), (int)this.expectedNumKeyRefs, (String)"# of KeyReference children");
    }

    @Test
    public void testSingleElementMarshall() {
        ReferenceList rl = (ReferenceList)this.buildXMLObject(ReferenceList.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)rl);
    }

    @Test
    public void testChildElementsMarshall() {
        ReferenceList rl = (ReferenceList)this.buildXMLObject(ReferenceList.DEFAULT_ELEMENT_NAME);
        rl.getReferences().add((DataReference)this.buildXMLObject(DataReference.DEFAULT_ELEMENT_NAME));
        rl.getReferences().add((KeyReference)this.buildXMLObject(KeyReference.DEFAULT_ELEMENT_NAME));
        rl.getReferences().add((DataReference)this.buildXMLObject(DataReference.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)rl);
    }
}

