/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ChainingEncryptedKeyResolverTest
extends XMLObjectBaseTestCase {
    private ChainingEncryptedKeyResolver resolver;
    private List<EncryptedKeyResolver> resolverChain;
    private Set<String> recipients;

    @BeforeMethod
    protected void setUp() throws Exception {
        InlineEncryptedKeyResolver inline = new InlineEncryptedKeyResolver();
        SimpleRetrievalMethodEncryptedKeyResolver rm = new SimpleRetrievalMethodEncryptedKeyResolver();
        this.resolverChain = Arrays.asList(inline, rm);
        this.recipients = new HashSet<String>();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testEmptyChain() {
        String filename = "/org/opensaml/xmlsec/encryption/support/ChainingEncryptedKeyResolverSingleInline.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getEncryptedKeys().isEmpty());
        Assert.assertTrue((boolean)keyInfo.getRetrievalMethods().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new ChainingEncryptedKeyResolver(new ArrayList());
        this.generateList(encData, (EncryptedKeyResolver)this.resolver, null);
    }

    @Test
    public void testSingleEKInline() {
        String filename = "/org/opensaml/xmlsec/encryption/support/ChainingEncryptedKeyResolverSingleInline.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getEncryptedKeys().isEmpty());
        Assert.assertTrue((boolean)keyInfo.getRetrievalMethods().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.recipients.add("foo");
        this.resolver = new ChainingEncryptedKeyResolver(this.resolverChain);
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, this.recipients);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testSingleEKRetrievalMethod() {
        String filename = "/org/opensaml/xmlsec/encryption/support/ChainingEncryptedKeyResolverSingleRetrievalMethod.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertTrue((boolean)keyInfo.getEncryptedKeys().isEmpty());
        Assert.assertFalse((boolean)keyInfo.getRetrievalMethods().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.recipients.add("foo");
        this.resolver = new ChainingEncryptedKeyResolver(this.resolverChain);
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, this.recipients);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKWithOneRecipient() {
        String filename = "/org/opensaml/xmlsec/encryption/support/ChainingEncryptedKeyResolverMultiple.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getEncryptedKeys().isEmpty());
        Assert.assertFalse((boolean)keyInfo.getRetrievalMethods().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.recipients.add("foo");
        this.resolver = new ChainingEncryptedKeyResolver(this.resolverChain);
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, this.recipients);
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(3) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKWithTwoRecipients() {
        String filename = "/org/opensaml/xmlsec/encryption/support/ChainingEncryptedKeyResolverMultiple.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getEncryptedKeys().isEmpty());
        Assert.assertFalse((boolean)keyInfo.getRetrievalMethods().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.recipients.add("foo");
        this.recipients.add("baz");
        this.resolver = new ChainingEncryptedKeyResolver(this.resolverChain);
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, this.recipients);
        Assert.assertEquals((int)resolved.size(), (int)4, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(2) == allKeys.get(3) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(3) == allKeys.get(5) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiRecipientsCtorAndArgs() {
        String filename = "/org/opensaml/xmlsec/encryption/support/ChainingEncryptedKeyResolverMultiple.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getEncryptedKeys().isEmpty());
        Assert.assertFalse((boolean)keyInfo.getRetrievalMethods().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.recipients.add("baz");
        this.resolver = new ChainingEncryptedKeyResolver(this.resolverChain, CollectionSupport.singleton((Object)"foo"));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, this.recipients);
        Assert.assertEquals((int)resolved.size(), (int)4, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(2) == allKeys.get(3) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(3) == allKeys.get(5) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    private List<EncryptedKey> getEncryptedKeys(@Nonnull SignableSimpleXMLObject sxo) {
        ArrayList<EncryptedKey> allKeys = new ArrayList<EncryptedKey>();
        EncryptedData edata = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (edata != null);
        KeyInfo keyInfo = edata.getKeyInfo();
        assert (keyInfo != null);
        allKeys.addAll(keyInfo.getEncryptedKeys());
        for (XMLObject xmlObject : sxo.getUnknownXMLObjects()) {
            if (!(xmlObject instanceof EncryptedKey)) continue;
            allKeys.add((EncryptedKey)xmlObject);
        }
        return allKeys;
    }

    @Nonnull
    private List<EncryptedKey> generateList(@Nonnull EncryptedData encData, @Nonnull EncryptedKeyResolver ekResolver, @Nullable Set<String> recipients) {
        return (List)((NonnullSupplier)StreamSupport.stream(ekResolver.resolve(encData, recipients).spliterator(), false).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
    }
}

