/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.DecryptionParametersResolver;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.KANonce;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.impl.BasicDecryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicDecryptionParametersResolver;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.AgreementMethodKeyInfoProvider;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.DigestMethod;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.testing.XMLSecurityTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DHWithLegacyKDFTest
extends XMLObjectBaseTestCase {
    private String targetFile;
    private Credential recipientCredPrivate;
    private Credential recipientCredPublic;
    private CollectionCredentialResolver localCredentialResolver;
    private LocalKeyInfoCredentialResolver localKeyInfoResolver;
    private Encrypter encrypter;
    private EncryptionParametersResolver encParamsResolver;
    private CriteriaSet encCriteria;
    private BasicEncryptionConfiguration encConfig;
    private BasicEncryptionConfiguration encConfig2;
    private DecryptionParametersResolver decryptParamsResolver;
    private CriteriaSet decryptCriteria;
    private BasicDecryptionConfiguration decryptConfig;

    @BeforeClass
    public void beforeClass() throws Exception {
        this.targetFile = "/org/opensaml/xmlsec/encryption/support/SimpleEncryptionTest.xml";
        KeyPair kp = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        this.recipientCredPrivate = new BasicCredential(kp.getPublic(), kp.getPrivate());
        this.recipientCredPublic = new BasicCredential(kp.getPublic());
        this.encrypter = new Encrypter();
        this.encParamsResolver = new BasicEncryptionParametersResolver();
        this.decryptParamsResolver = new BasicDecryptionParametersResolver();
        this.localCredentialResolver = new CollectionCredentialResolver(Set.of(this.recipientCredPrivate));
        ArrayList<KeyInfoProvider> keyInfoProviders = new ArrayList<KeyInfoProvider>(XMLSecurityTestingSupport.getBasicInlineKeyInfoProviders());
        keyInfoProviders.add((KeyInfoProvider)new AgreementMethodKeyInfoProvider());
        this.localKeyInfoResolver = new LocalKeyInfoCredentialResolver(keyInfoProviders, (CredentialResolver)this.localCredentialResolver);
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.encConfig = new BasicEncryptionConfiguration();
        this.encConfig2 = new BasicEncryptionConfiguration();
        this.encCriteria = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{this.encConfig, this.encConfig2, (EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class)})});
        KeyAgreementEncryptionConfiguration kaConfig = new KeyAgreementEncryptionConfiguration();
        kaConfig.setAlgorithm("http://www.w3.org/2001/04/xmlenc#dh");
        org.opensaml.xmlsec.agreement.impl.DigestMethod dm = new org.opensaml.xmlsec.agreement.impl.DigestMethod();
        dm.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        dm.initialize();
        org.opensaml.xmlsec.agreement.impl.KANonce nonce = new org.opensaml.xmlsec.agreement.impl.KANonce();
        nonce.initialize();
        kaConfig.setParameters((Collection)CollectionSupport.setOf((Object)dm, (Object)nonce));
        this.encConfig2.setKeyAgreementConfigurations(Map.of("DH", kaConfig));
        this.decryptConfig = new BasicDecryptionConfiguration();
        this.decryptConfig.setDataKeyInfoCredentialResolver((KeyInfoCredentialResolver)this.localKeyInfoResolver);
        this.decryptConfig.setKEKKeyInfoCredentialResolver((KeyInfoCredentialResolver)this.localKeyInfoResolver);
        this.decryptCriteria = new CriteriaSet(new Criterion[]{new DecryptionConfigurationCriterion(new DecryptionConfiguration[]{this.decryptConfig, (DecryptionConfiguration)ConfigurationService.get(DecryptionConfiguration.class)})});
    }

    @Test
    public void roundtripDirectDataEncryption() throws Exception {
        this.encConfig.setDataEncryptionCredentials(List.of(this.recipientCredPublic));
        this.testRoundtrip("http://www.w3.org/2001/04/xmlenc#aes128-cbc", null, "http://www.w3.org/2001/04/xmlenc#sha256", true);
    }

    @Test
    public void roundtripDirectDataEncryptionWithAlgorithmOverrides() throws Exception {
        this.encConfig.setDataEncryptionCredentials(List.of(this.recipientCredPublic));
        this.encConfig.setDataEncryptionAlgorithms(List.of("http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        this.testRoundtrip("http://www.w3.org/2009/xmlenc11#aes128-gcm", null, "http://www.w3.org/2001/04/xmlenc#sha256", true);
    }

    @Test
    public void roundtripWithKeyWrap() throws Exception {
        this.encConfig.setKeyTransportEncryptionCredentials(List.of(this.recipientCredPublic));
        this.testRoundtrip("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#sha256", true);
    }

    @Test
    public void roundtripWithKeyWrapAndAlgorithmOverrides() throws Exception {
        this.encConfig.setKeyTransportEncryptionCredentials(List.of(this.recipientCredPublic));
        this.encConfig.setKeyTransportEncryptionAlgorithms(List.of("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        this.encConfig.setDataEncryptionAlgorithms(List.of("http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        this.testRoundtrip("http://www.w3.org/2009/xmlenc11#aes128-gcm", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#sha256", true);
    }

    @Test
    public void roundtripWithSHA512AndNoNonce() throws Exception {
        this.encConfig.setDataEncryptionCredentials(List.of(this.recipientCredPublic));
        KeyAgreementEncryptionConfiguration kaConfig = new KeyAgreementEncryptionConfiguration();
        org.opensaml.xmlsec.agreement.impl.DigestMethod dm = new org.opensaml.xmlsec.agreement.impl.DigestMethod();
        dm.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
        kaConfig.setParameters(Set.of(dm));
        this.encConfig.setKeyAgreementConfigurations(Map.of("DH", kaConfig));
        this.testRoundtrip("http://www.w3.org/2001/04/xmlenc#aes128-cbc", null, "http://www.w3.org/2001/04/xmlenc#sha512", false);
    }

    private void testRoundtrip(String expectedDataAlgo, String expectedKEKAlgo, String expectedDigestMethod, boolean nonceExpected) throws Exception {
        AgreementMethod agreementMethod;
        SignableSimpleXMLObject sxoOrig = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxoOrig != null);
        EncryptionParameters encParams = (EncryptionParameters)this.encParamsResolver.resolveSingle((Object)this.encCriteria);
        assert (encParams != null);
        DataEncryptionParameters dataEncParams = new DataEncryptionParameters(encParams);
        List<KeyEncryptionParameters> kekParams = encParams.getKeyTransportEncryptionCredential() != null ? List.of(new KeyEncryptionParameters(encParams, null)) : CollectionSupport.emptyList();
        EncryptedData encryptedDataOrig = this.encrypter.encryptElement((XMLObject)sxoOrig, dataEncParams, kekParams);
        Assert.assertNotNull((Object)encryptedDataOrig);
        KeyInfo encKeyInfo = encryptedDataOrig.getKeyInfo();
        assert (encKeyInfo != null);
        if (expectedDataAlgo != null) {
            EncryptionMethod method = encryptedDataOrig.getEncryptionMethod();
            assert (method != null);
            Assert.assertEquals((String)method.getAlgorithm(), (String)expectedDataAlgo);
        }
        if (expectedKEKAlgo != null) {
            EncryptedKey ekey = (EncryptedKey)encKeyInfo.getEncryptedKeys().get(0);
            assert (ekey != null);
            EncryptionMethod nestedMethod = ekey.getEncryptionMethod();
            assert (nestedMethod != null);
            Assert.assertEquals((String)nestedMethod.getAlgorithm(), (String)expectedKEKAlgo);
        }
        if (!encKeyInfo.getEncryptedKeys().isEmpty()) {
            EncryptedKey ekey = (EncryptedKey)encKeyInfo.getEncryptedKeys().get(0);
            assert (ekey != null);
            KeyInfo nestedKeyInfo = ekey.getKeyInfo();
            assert (nestedKeyInfo != null);
            agreementMethod = (AgreementMethod)nestedKeyInfo.getAgreementMethods().get(0);
        } else {
            agreementMethod = (AgreementMethod)encKeyInfo.getAgreementMethods().get(0);
        }
        Assert.assertNotNull((Object)agreementMethod);
        Assert.assertEquals((String)agreementMethod.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#dh");
        if (expectedDigestMethod != null) {
            DigestMethod digestMethod = (DigestMethod)agreementMethod.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME).get(0);
            Assert.assertNotNull((Object)digestMethod);
            Assert.assertEquals((String)digestMethod.getAlgorithm(), (String)expectedDigestMethod);
        }
        KANonce nonce = agreementMethod.getKANonce();
        if (nonceExpected) {
            assert (nonce != null);
            Assert.assertNotNull((Object)nonce.getValue());
        } else {
            Assert.assertNull((Object)nonce);
        }
        Element domEncrypted = XMLObjectSupport.marshall((XMLObject)encryptedDataOrig);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)domEncrypted, (OutputStream)baos);
        baos.flush();
        byte[] bytesEncrypted = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytesEncrypted);
        ParserPool parser = XMLObjectProviderRegistrySupport.getParserPool();
        assert (parser != null);
        EncryptedData encryptedData = (EncryptedData)XMLObjectSupport.unmarshallFromInputStream((ParserPool)parser, (InputStream)bais);
        Assert.assertNotNull((Object)encryptedData);
        DecryptionParameters decryptParams = (DecryptionParameters)this.decryptParamsResolver.resolveSingle((Object)this.decryptCriteria);
        Decrypter decrypter = new Decrypter(decryptParams);
        XMLObject decryptedXMLObject = decrypter.decryptData(encryptedData);
        Assert.assertNotNull((Object)decryptedXMLObject);
        Assert.assertTrue((boolean)(decryptedXMLObject instanceof SignableSimpleXMLObject));
        Element origDOM = sxoOrig.getDOM();
        assert (origDOM != null);
        this.assertXMLEquals(origDOM.getOwnerDocument(), decryptedXMLObject);
    }
}

