/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support.tests;

import javax.annotation.Nonnull;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class EncryptionClonedContentTest
extends XMLObjectBaseTestCase {
    private String targetFile = "/org/opensaml/xmlsec/encryption/support/SimpleEncryptionTest.xml";
    @Nonnull
    private final String algoURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";

    @Test
    public void testEncryptDecrypt() throws Exception {
        SignableSimpleXMLObject origXMLObject = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (origXMLObject != null);
        SignableSimpleXMLObject clonedXMLObject = (SignableSimpleXMLObject)XMLObjectSupport.cloneXMLObject((XMLObject)origXMLObject);
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        DataEncryptionParameters encParams = new DataEncryptionParameters();
        encParams.setAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encParams.setEncryptionCredential(encCred);
        Encrypter encrypter = new Encrypter();
        EncryptedData encryptedData = encrypter.encryptElement((XMLObject)clonedXMLObject, encParams);
        Assert.assertNotNull((Object)encryptedData);
        EncryptionMethod method = encryptedData.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)method.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        StaticKeyInfoCredentialResolver dataKeyInfoResolver = new StaticKeyInfoCredentialResolver(encCred);
        Decrypter decrypter = new Decrypter((KeyInfoCredentialResolver)dataKeyInfoResolver, null, null);
        XMLObject decryptedXMLObject = decrypter.decryptData(encryptedData);
        Assert.assertNotNull((Object)decryptedXMLObject);
        Assert.assertTrue((boolean)(decryptedXMLObject instanceof SignableSimpleXMLObject));
        Element origDOM = origXMLObject.getDOM();
        assert (origDOM != null);
        this.assertXMLEquals(origDOM.getOwnerDocument(), decryptedXMLObject);
    }
}

