/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support.tests;

import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.testing.SecurityProviderTestSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.MGF;
import org.opensaml.xmlsec.encryption.OAEPparams;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoGenerator;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.DigestMethod;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class SimpleEncryptionTest
extends XMLObjectBaseTestCase {
    private Encrypter encrypter;
    private DataEncryptionParameters encParams;
    private String algoURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private List<KeyEncryptionParameters> kekParamsList;
    private KeyEncryptionParameters kekParamsAES;
    private String kekURIAES = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    private KeyEncryptionParameters kekParamsRSA;
    private String kekURIRSA = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private KeyInfo keyInfo;
    private KeyInfo kekKeyInfoAES;
    private KeyInfo kekKeyInfoRSA;
    private String expectedKeyName = "SuperSecretKey";
    private String expectedKEKKeyNameAES = "KEKKeyRSA";
    private String expectedKEKKeyNameRSA;
    private String expectedRecipientRSA = "CoolRecipientRSA";
    private String expectedRecipientAES = "CoolRecipientAES";
    private String targetFile = "/org/opensaml/xmlsec/encryption/support/SimpleEncryptionTest.xml";
    private SecurityProviderTestSupport providerSupport = new SecurityProviderTestSupport();

    @BeforeMethod
    protected void setUp() throws Exception {
        this.encrypter = new Encrypter();
        this.encParams = new DataEncryptionParameters();
        this.encParams.setAlgorithm(this.algoURI);
        this.encParams.setEncryptionCredential(AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.algoURI));
        this.kekParamsList = new ArrayList<KeyEncryptionParameters>();
        this.kekParamsAES = new KeyEncryptionParameters();
        this.kekParamsAES.setAlgorithm(this.kekURIAES);
        this.kekParamsAES.setEncryptionCredential(AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.kekURIAES));
        this.kekParamsAES.setRecipient(this.expectedRecipientAES);
        this.kekParamsRSA = new KeyEncryptionParameters();
        this.kekParamsRSA.setAlgorithm(this.kekURIRSA);
        this.kekParamsRSA.setEncryptionCredential(AlgorithmSupport.generateKeyPairAndCredential((String)this.kekURIRSA, (int)1024, (boolean)false));
        this.kekParamsRSA.setRecipient(this.expectedRecipientRSA);
        this.keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyName);
        this.keyInfo.getKeyNames().add(keyName);
        this.kekKeyInfoAES = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKEKKeyNameAES);
        this.kekKeyInfoAES.getKeyNames().add(keyName);
        this.kekKeyInfoRSA = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKEKKeyNameRSA);
        this.kekKeyInfoRSA.getKeyNames().add(keyName);
    }

    @Test
    public void testEncryptDataWithKeyNameNoKEK() {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        EncryptedData encData = null;
        try {
            encData = this.encrypter.encryptElement((XMLObject)sxo, this.encParams);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encData != null);
        EncryptionMethod method = encData.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)encData.getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertEquals((String)((KeyName)keyInfo.getKeyNames().get(0)).getValue(), (String)this.expectedKeyName, (String)"KeyName");
        Assert.assertEquals((int)keyInfo.getEncryptedKeys().size(), (int)0, (String)"Number of EncryptedKeys");
    }

    @Test
    public void testEncryptDataSingleKEK() {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        EncryptedData encData = null;
        try {
            encData = this.encrypter.encryptElement((XMLObject)sxo, this.encParams, this.kekParamsRSA);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encData != null);
        EncryptionMethod method = encData.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)encData.getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        List encKeys = keyInfo.getEncryptedKeys();
        Assert.assertEquals((int)keyInfo.getEncryptedKeys().size(), (int)1, (String)"Number of EncryptedKeys");
        this.checkKEKRSA((EncryptedKey)encKeys.get(0), true);
    }

    @Test
    public void testEncryptDataMultipleKEK() {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        this.kekParamsAES.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoAES));
        this.kekParamsList.add(this.kekParamsRSA);
        this.kekParamsList.add(this.kekParamsAES);
        EncryptedData encData = null;
        try {
            encData = this.encrypter.encryptElement((XMLObject)sxo, this.encParams, this.kekParamsList);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encData != null);
        EncryptionMethod method = encData.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)encData.getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        List encKeys = keyInfo.getEncryptedKeys();
        Assert.assertEquals((int)keyInfo.getEncryptedKeys().size(), (int)2, (String)"Number of EncryptedKeys");
        this.checkKEKRSA((EncryptedKey)encKeys.get(0), true);
        this.checkKEKAES((EncryptedKey)encKeys.get(1), true);
    }

    @Test
    public void testEncryptContentWithKeyNameNoKEK() {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        EncryptedData encData = null;
        try {
            encData = this.encrypter.encryptElementContent((XMLObject)sxo, this.encParams);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encData != null);
        EncryptionMethod method = encData.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)encData.getType(), (String)"http://www.w3.org/2001/04/xmlenc#Content", (String)"Type attribute");
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertEquals((String)((KeyName)keyInfo.getKeyNames().get(0)).getValue(), (String)this.expectedKeyName, (String)"KeyName");
        Assert.assertEquals((int)keyInfo.getEncryptedKeys().size(), (int)0, (String)"Number of EncryptedKeys");
    }

    @Test
    public void testEncryptContentSingleKEK() {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        EncryptedData encData = null;
        try {
            encData = this.encrypter.encryptElementContent((XMLObject)sxo, this.encParams, this.kekParamsRSA);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encData != null);
        EncryptionMethod method = encData.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)encData.getType(), (String)"http://www.w3.org/2001/04/xmlenc#Content", (String)"Type attribute");
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        List encKeys = keyInfo.getEncryptedKeys();
        Assert.assertEquals((int)keyInfo.getEncryptedKeys().size(), (int)1, (String)"Number of EncryptedKeys");
        this.checkKEKRSA((EncryptedKey)encKeys.get(0), true);
    }

    @Test
    public void testEncryptContentMultipleKEK() {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        this.kekParamsAES.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoAES));
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        this.kekParamsList.add(this.kekParamsRSA);
        this.kekParamsList.add(this.kekParamsAES);
        EncryptedData encData = null;
        try {
            encData = this.encrypter.encryptElementContent((XMLObject)sxo, this.encParams, this.kekParamsList);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encData != null);
        EncryptionMethod method = encData.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)encData.getType(), (String)"http://www.w3.org/2001/04/xmlenc#Content", (String)"Type attribute");
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        List encKeys = keyInfo.getEncryptedKeys();
        Assert.assertEquals((int)keyInfo.getEncryptedKeys().size(), (int)2, (String)"Number of EncryptedKeys");
        this.checkKEKRSA((EncryptedKey)encKeys.get(0), true);
        this.checkKEKAES((EncryptedKey)encKeys.get(1), true);
    }

    @Test
    public void testEncryptKeySingleKEK() throws NoSuchAlgorithmException, NoSuchProviderException, XMLParserException, KeyException {
        SecretKey targetKey = AlgorithmSupport.generateSymmetricKey((String)this.algoURI);
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        EncryptedKey encKey = null;
        Document ownerDocument = parserPool.newDocument();
        try {
            encKey = this.encrypter.encryptKey((Key)targetKey, this.kekParamsRSA, ownerDocument);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encKey != null);
        this.checkKEKRSA(encKey, true);
    }

    @Test
    public void testEncryptKeyMultipleKEK() throws NoSuchAlgorithmException, NoSuchProviderException, XMLParserException, KeyException {
        SecretKey targetKey = AlgorithmSupport.generateSymmetricKey((String)this.algoURI);
        this.kekParamsAES.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoAES));
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        this.kekParamsList.add(this.kekParamsAES);
        this.kekParamsList.add(this.kekParamsRSA);
        List encKeys = null;
        Document ownerDocument = parserPool.newDocument();
        try {
            encKeys = this.encrypter.encryptKey((Key)targetKey, this.kekParamsList, ownerDocument);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encKeys != null);
        Assert.assertEquals((int)encKeys.size(), (int)2, (String)"Number of EncryptedKeys");
        this.checkKEKAES((EncryptedKey)encKeys.get(0), true);
        this.checkKEKRSA((EncryptedKey)encKeys.get(1), true);
    }

    @Test
    public void testAutoKeyGen() {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        this.encParams.setEncryptionCredential(null);
        this.kekParamsList.add(this.kekParamsRSA);
        EncryptedData encData = null;
        try {
            encData = this.encrypter.encryptElement((XMLObject)sxo, this.encParams, this.kekParamsRSA);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        Assert.assertNotNull(encData);
        try {
            encData = this.encrypter.encryptElement((XMLObject)sxo, this.encParams, this.kekParamsList);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        Assert.assertNotNull((Object)encData);
    }

    @Test
    public void testAutoKeyGenNoKEK() {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        this.encParams.setEncryptionCredential(null);
        this.kekParamsList.clear();
        try {
            this.encrypter.encryptElement((XMLObject)sxo, this.encParams);
            Assert.fail((String)"Object encryption should have failed: no KEK supplied with auto key generation for data encryption");
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
        try {
            this.encrypter.encryptElement((XMLObject)sxo, this.encParams, this.kekParamsList);
            Assert.fail((String)"Object encryption should have failed: no KEK supplied with auto key generation for data encryption");
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptKeyDigestMethodsRSAOAEP() throws NoSuchAlgorithmException, NoSuchProviderException, XMLParserException, KeyException {
        SecretKey targetKey = AlgorithmSupport.generateSymmetricKey((String)this.algoURI);
        this.kekParamsRSA.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        EncryptedKey encKey = null;
        Document ownerDocument = parserPool.newDocument();
        try {
            encKey = this.encrypter.encryptKey((Key)targetKey, this.kekParamsRSA, ownerDocument);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encKey != null);
        EncryptionMethod method = encKey.getEncryptionMethod();
        assert (method != null);
        Assert.assertFalse((boolean)method.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME).isEmpty(), (String)"EncryptedKey/EncryptionMethod/DigestMethod list was empty");
        DigestMethod dm = (DigestMethod)method.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)dm.getAlgorithm(), (String)"http://www.w3.org/2000/09/xmldsig#sha1", (String)"DigestMethod algorithm URI had unexpected value");
    }

    @Test
    public void testEncryptKeyDigestMethodsRSAv15() throws NoSuchAlgorithmException, NoSuchProviderException, XMLParserException, KeyException {
        SecretKey targetKey = AlgorithmSupport.generateSymmetricKey((String)this.algoURI);
        this.kekParamsRSA.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        EncryptedKey encKey = null;
        Document ownerDocument = parserPool.newDocument();
        try {
            encKey = this.encrypter.encryptKey((Key)targetKey, this.kekParamsRSA, ownerDocument);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + e));
        }
        assert (encKey != null);
        EncryptionMethod method = encKey.getEncryptionMethod();
        assert (method != null);
        Assert.assertTrue((boolean)method.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME).isEmpty(), (String)"EncryptedKey/EncryptionMethod/DigestMethod list was NOT empty");
    }

    @Test
    public void testEncryptDataBadKEKDSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        assert (sxo != null);
        KeyEncryptionParameters kekParamsDSA = new KeyEncryptionParameters();
        KeyPair kp = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        kekParamsDSA.setEncryptionCredential((Credential)CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null));
        try {
            this.encrypter.encryptElement((XMLObject)sxo, this.encParams, kekParamsDSA);
            Assert.fail((String)"Object encryption succeeded, should have failed with DSA key attempt");
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRSAOAEPParameters() throws NoSuchAlgorithmException, NoSuchProviderException, XMLParserException, KeyException, EncryptionException {
        this.providerSupport.loadBC();
        try {
            Document ownerDocument = parserPool.newDocument();
            SecretKey targetKey = AlgorithmSupport.generateSymmetricKey((String)this.algoURI);
            String controlOAEPParams = "9lWu3Q==";
            KeyEncryptionParameters kekParams = new KeyEncryptionParameters();
            kekParams.setEncryptionCredential(AlgorithmSupport.generateKeyPairAndCredential((String)this.kekURIRSA, (int)1024, (boolean)false));
            kekParams.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
            kekParams.setRSAOAEPParameters(null);
            EncryptedKey encKey = this.encrypter.encryptKey((Key)targetKey, kekParams, ownerDocument);
            Assert.assertEquals((String)this.getDigestMethod(encKey), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
            Assert.assertNull((Object)this.getMGF(encKey));
            Assert.assertNull((Object)this.getOAEPParams(encKey));
            kekParams.setRSAOAEPParameters(new RSAOAEPParameters());
            encKey = this.encrypter.encryptKey((Key)targetKey, kekParams, ownerDocument);
            Assert.assertEquals((String)this.getDigestMethod(encKey), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
            Assert.assertNull((Object)this.getMGF(encKey));
            Assert.assertNull((Object)this.getOAEPParams(encKey));
            kekParams.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2009/xmlenc11#mgf1sha256", controlOAEPParams));
            encKey = this.encrypter.encryptKey((Key)targetKey, kekParams, ownerDocument);
            Assert.assertEquals((String)this.getDigestMethod(encKey), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
            Assert.assertNull((Object)this.getMGF(encKey));
            Assert.assertEquals((String)this.getOAEPParams(encKey), (String)controlOAEPParams);
            kekParams.setAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep");
            kekParams.setRSAOAEPParameters(null);
            encKey = this.encrypter.encryptKey((Key)targetKey, kekParams, ownerDocument);
            Assert.assertEquals((String)this.getDigestMethod(encKey), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
            Assert.assertEquals((String)this.getMGF(encKey), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha1");
            Assert.assertNull((Object)this.getOAEPParams(encKey));
            kekParams.setRSAOAEPParameters(new RSAOAEPParameters());
            encKey = this.encrypter.encryptKey((Key)targetKey, kekParams, ownerDocument);
            Assert.assertEquals((String)this.getDigestMethod(encKey), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
            Assert.assertEquals((String)this.getMGF(encKey), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha1");
            Assert.assertNull((Object)this.getOAEPParams(encKey));
            kekParams.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2009/xmlenc11#mgf1sha256", controlOAEPParams));
            encKey = this.encrypter.encryptKey((Key)targetKey, kekParams, ownerDocument);
            Assert.assertEquals((String)this.getDigestMethod(encKey), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
            Assert.assertEquals((String)this.getMGF(encKey), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha256");
            Assert.assertEquals((String)this.getOAEPParams(encKey), (String)controlOAEPParams);
        }
        finally {
            this.providerSupport.unloadBC();
        }
    }

    private void checkKEKAES(@Nonnull EncryptedKey encKey, boolean hasKeyInfo) {
        EncryptionMethod method = encKey.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.kekURIAES, (String)"Algorithm attribute");
        Assert.assertEquals((String)encKey.getRecipient(), (String)this.expectedRecipientAES, (String)"Recipient attribute");
        if (!hasKeyInfo) {
            Assert.assertNull((Object)encKey.getKeyInfo(), (String)"Unexpected KeyInfo was present");
            return;
        }
        KeyInfo keyInfo = encKey.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertNotNull(keyInfo.getKeyNames().get(0), (String)"KeyName was not present");
        Assert.assertEquals((String)((KeyName)keyInfo.getKeyNames().get(0)).getValue(), (String)this.expectedKEKKeyNameAES, (String)"Unexpected KEK KeyName");
    }

    private void checkKEKRSA(@Nonnull EncryptedKey encKey, boolean hasKeyInfo) {
        EncryptionMethod method = encKey.getEncryptionMethod();
        assert (method != null);
        Assert.assertEquals((String)method.getAlgorithm(), (String)this.kekURIRSA, (String)"Algorithm attribute");
        Assert.assertEquals((String)encKey.getRecipient(), (String)this.expectedRecipientRSA, (String)"Recipient attribute");
        if (!hasKeyInfo) {
            Assert.assertNull((Object)encKey.getKeyInfo(), (String)"Unexpected KeyInfo was present");
            return;
        }
        KeyInfo keyInfo = encKey.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertNotNull(keyInfo.getKeyNames().get(0), (String)"KeyName was not present");
        Assert.assertEquals((String)((KeyName)keyInfo.getKeyNames().get(0)).getValue(), (String)this.expectedKEKKeyNameRSA, (String)"Unexpected KEK KeyName");
    }

    private String getDigestMethod(@Nonnull EncryptedKey encryptedKey) {
        EncryptionMethod method = encryptedKey.getEncryptionMethod();
        assert (method != null);
        List digestMethods = method.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME);
        if (digestMethods != null && digestMethods.size() > 0) {
            return ((DigestMethod)digestMethods.get(0)).getAlgorithm();
        }
        return null;
    }

    private String getMGF(@Nonnull EncryptedKey encryptedKey) {
        EncryptionMethod method = encryptedKey.getEncryptionMethod();
        assert (method != null);
        List mgfs = method.getUnknownXMLObjects(MGF.DEFAULT_ELEMENT_NAME);
        if (mgfs != null && mgfs.size() > 0) {
            return ((MGF)mgfs.get(0)).getAlgorithm();
        }
        return null;
    }

    private String getOAEPParams(@Nonnull EncryptedKey encryptedKey) {
        EncryptionMethod method = encryptedKey.getEncryptionMethod();
        assert (method != null);
        OAEPparams params = method.getOAEPparams();
        if (params != null) {
            return params.getValue();
        }
        return null;
    }
}

