/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyInfoReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleKeyInfoReferenceEncryptedKeyResolverTest
extends XMLObjectBaseTestCase {
    private SimpleKeyInfoReferenceEncryptedKeyResolver resolver;

    @Test
    public void testSingleEKNoRecipient() {
        String filename = "/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverSingle.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement("/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverSingle.xml");
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getXMLObjects(KeyInfoReference.DEFAULT_ELEMENT_NAME).isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, null);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testSingleEKWithRecipient() {
        String filename = "/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverSingle.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement("/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverSingle.xml");
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getXMLObjects(KeyInfoReference.DEFAULT_ELEMENT_NAME).isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, CollectionSupport.singleton((Object)"foo"));
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKWithOneRecipient() {
        String filename = "/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverMultiple.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement("/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverMultiple.xml");
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getKeyInfoReferences().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, CollectionSupport.singleton((Object)"foo"));
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKWithTwoRecipients() {
        String filename = "/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverMultiple.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement("/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverMultiple.xml");
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getKeyInfoReferences().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, CollectionSupport.setOf((Object)"foo", (Object)"baz"));
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiRecipientsCtorAndArgs() {
        String filename = "/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverMultiple.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement("/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverMultiple.xml");
        assert (sxo != null);
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        assert (encData != null);
        KeyInfo keyInfo = encData.getKeyInfo();
        assert (keyInfo != null);
        Assert.assertFalse((boolean)keyInfo.getKeyInfoReferences().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver(CollectionSupport.singleton((Object)"foo"));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver, CollectionSupport.singleton((Object)"baz"));
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Nonnull
    private List<EncryptedKey> getEncryptedKeys(@Nonnull SignableSimpleXMLObject sxo) {
        ArrayList<EncryptedKey> allKeys = new ArrayList<EncryptedKey>();
        for (XMLObject xmlObject : sxo.getUnknownXMLObjects()) {
            if (!(xmlObject instanceof KeyInfo)) continue;
            allKeys.addAll(((KeyInfo)xmlObject).getEncryptedKeys());
        }
        return allKeys;
    }

    @Nonnull
    private List<EncryptedKey> generateList(@Nonnull EncryptedData encData, @Nonnull EncryptedKeyResolver ekResolver, @Nullable Set<String> recipients) {
        return (List)((NonnullSupplier)StreamSupport.stream(ekResolver.resolve(encData, recipients).spliterator(), false).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
    }
}

