/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;

public class AlgorithmPolicyConfigurationCriterion
implements Criterion {
    @Nonnull
    private List<AlgorithmPolicyConfiguration> configs;

    public AlgorithmPolicyConfigurationCriterion(@Nonnull @NotEmpty List<AlgorithmPolicyConfiguration> configurations) {
        this.configs = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(configurations, (String)"List of configurations may not be null")));
        Constraint.isNotEmpty(this.configs, (String)"At least one configuration is required");
    }

    public AlgorithmPolicyConfigurationCriterion(AlgorithmPolicyConfiguration ... configurations) {
        this.configs = CollectionSupport.listOf((Object[])((AlgorithmPolicyConfiguration[])Constraint.isNotNull((Object)configurations, (String)"List of configurations may not be null")));
        Constraint.isNotEmpty(this.configs, (String)"At least one configuration is required");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    @NotEmpty
    public List<AlgorithmPolicyConfiguration> getConfigurations() {
        return this.configs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AlgorithmPolicyConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AlgorithmPolicyConfigurationCriterion) {
            AlgorithmPolicyConfigurationCriterion other = (AlgorithmPolicyConfigurationCriterion)obj;
            return this.configs.equals(other.getConfigurations());
        }
        return false;
    }
}

