/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Arrays;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.impl.BasicAlgorithmPolicyConfiguration;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicAlgorithmPolicyConfigurationTest {
    private BasicAlgorithmPolicyConfiguration config;

    @BeforeMethod
    public void setUp() {
        this.config = new BasicAlgorithmPolicyConfiguration();
    }

    @Test
    public void testDefaults() {
        Assert.assertEquals((boolean)this.config.isIncludeMerge(), (boolean)false);
        Assert.assertNotNull((Object)this.config.getIncludedAlgorithms());
        Assert.assertTrue((boolean)this.config.getIncludedAlgorithms().isEmpty());
        Assert.assertEquals((boolean)this.config.isExcludeMerge(), (boolean)true);
        Assert.assertNotNull((Object)this.config.getExcludedAlgorithms());
        Assert.assertTrue((boolean)this.config.getExcludedAlgorithms().isEmpty());
        Assert.assertEquals((Object)this.config.getIncludeExcludePrecedence(), (Object)AlgorithmPolicyConfiguration.Precedence.INCLUDE);
    }

    @Test
    public void testValidWhitelist() {
        this.config.setIncludedAlgorithms(Arrays.asList("  A   ", null, "   B   ", null, "   C   "));
        Assert.assertEquals((int)this.config.getIncludedAlgorithms().size(), (int)3);
        Assert.assertTrue((boolean)this.config.getIncludedAlgorithms().contains("A"));
        Assert.assertTrue((boolean)this.config.getIncludedAlgorithms().contains("B"));
        Assert.assertTrue((boolean)this.config.getIncludedAlgorithms().contains("C"));
    }

    @Test
    public void testNullWhitelist() {
        this.config.setIncludedAlgorithms(null);
        Assert.assertNotNull((Object)this.config.getIncludedAlgorithms());
        Assert.assertTrue((boolean)this.config.getIncludedAlgorithms().isEmpty());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testWhitelistImmutable() {
        this.config.setIncludedAlgorithms(Arrays.asList("A", "B", "C"));
        this.config.getIncludedAlgorithms().add("D");
    }

    @Test
    public void testWhitelistMerge() {
        Assert.assertFalse((boolean)this.config.isIncludeMerge());
        this.config.setIncludeMerge(true);
        Assert.assertTrue((boolean)this.config.isIncludeMerge());
        this.config.setIncludeMerge(false);
        Assert.assertFalse((boolean)this.config.isIncludeMerge());
    }

    @Test
    public void testValidBlacklist() {
        this.config.setExcludedAlgorithms(Arrays.asList("   A   ", null, "   B   ", null, "   C   "));
        Assert.assertEquals((int)this.config.getExcludedAlgorithms().size(), (int)3);
        Assert.assertTrue((boolean)this.config.getExcludedAlgorithms().contains("A"));
        Assert.assertTrue((boolean)this.config.getExcludedAlgorithms().contains("B"));
        Assert.assertTrue((boolean)this.config.getExcludedAlgorithms().contains("C"));
    }

    @Test
    public void testNullBlacklist() {
        this.config.setExcludedAlgorithms(null);
        Assert.assertNotNull((Object)this.config.getExcludedAlgorithms());
        Assert.assertTrue((boolean)this.config.getExcludedAlgorithms().isEmpty());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testBlacklistImmutable() {
        this.config.setExcludedAlgorithms(Arrays.asList("A", "B", "C"));
        this.config.getExcludedAlgorithms().add("D");
    }

    @Test
    public void testBlacklistMerge() {
        Assert.assertTrue((boolean)this.config.isExcludeMerge());
        this.config.setExcludeMerge(false);
        Assert.assertFalse((boolean)this.config.isExcludeMerge());
        this.config.setExcludeMerge(true);
        Assert.assertTrue((boolean)this.config.isExcludeMerge());
    }

    @Test
    public void testValidPrecedence() {
        Assert.assertEquals((Object)this.config.getIncludeExcludePrecedence(), (Object)AlgorithmPolicyConfiguration.Precedence.INCLUDE);
        this.config.setIncludeExcludePrecedence(AlgorithmPolicyConfiguration.Precedence.INCLUDE);
        Assert.assertEquals((Object)this.config.getIncludeExcludePrecedence(), (Object)AlgorithmPolicyConfiguration.Precedence.INCLUDE);
        this.config.setIncludeExcludePrecedence(AlgorithmPolicyConfiguration.Precedence.EXCLUDE);
        Assert.assertEquals((Object)this.config.getIncludeExcludePrecedence(), (Object)AlgorithmPolicyConfiguration.Precedence.EXCLUDE);
    }
}

